/*
 * Decompiled with CFR 0.152.
 */
package org.fluentd.logger;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import org.fluentd.logger.sender.RawSocketSender;
import org.fluentd.logger.sender.Sender;

public class FluentLogger {
    private static Map<String, FluentLogger> loggers = new WeakHashMap<String, FluentLogger>();
    protected String tagPrefix;
    protected Sender sender;

    public static FluentLogger getLogger(String tag) {
        return FluentLogger.getLogger(tag, "localhost", 24224);
    }

    public static FluentLogger getLogger(String tag, String host, int port) {
        return FluentLogger.getLogger(tag, host, port, 3000, 0x100000);
    }

    public static synchronized FluentLogger getLogger(String tag, String host, int port, int timeout, int bufferCapacity) {
        String key = String.format("%s_%s_%d_%d_%d", tag, host, port, timeout, bufferCapacity);
        if (loggers.containsKey(key)) {
            return loggers.get(key);
        }
        Sender sender = null;
        Properties props = System.getProperties();
        if (!props.containsKey("fluentd.logger.sender.class")) {
            sender = new RawSocketSender(host, port, timeout, bufferCapacity);
        } else {
            String senderClassName = props.getProperty("fluentd.logger.sender.class");
            try {
                sender = FluentLogger.createSenderInstance(senderClassName, new Object[]{host, port, timeout, bufferCapacity});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        FluentLogger logger = new FluentLogger(tag, sender);
        loggers.put(key, logger);
        return logger;
    }

    private static Sender createSenderInstance(String className, Object[] params) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> cl = FluentLogger.class.getClassLoader().loadClass(className);
        Constructor<?> cons = cl.getDeclaredConstructor(String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        return (Sender)cons.newInstance(params);
    }

    static Map<String, FluentLogger> getLoggers() {
        return loggers;
    }

    public static synchronized void close() {
        for (FluentLogger logger : loggers.values()) {
            logger.close0();
        }
        loggers.clear();
    }

    protected FluentLogger() {
    }

    protected FluentLogger(String tag, Sender sender) {
        this.tagPrefix = tag;
        this.sender = sender;
    }

    public boolean log(String label, String key, Object value) {
        return this.log(label, key, value, 0L);
    }

    public boolean log(String label, String key, Object value, long timestamp) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(key, value);
        return this.log(label, data, timestamp);
    }

    public boolean log(String label, Map<String, Object> data) {
        return this.log(label, data, 0L);
    }

    public boolean log(String label, Map<String, Object> data, long timestamp) {
        if (timestamp != 0L) {
            return this.sender.emit(this.tagPrefix + "." + label, timestamp, data);
        }
        return this.sender.emit(this.tagPrefix + "." + label, data);
    }

    public void flush() throws IOException {
        this.sender.flush();
    }

    protected void close0() {
        if (this.sender != null) {
            this.sender.close();
            this.sender = null;
        }
    }

    public String toString() {
        return String.format("%s{tagPrefix=%s,sender=%s}", this.getClass().getName(), this.tagPrefix, this.sender.toString());
    }

    public void finalize() {
        if (this.sender != null) {
            this.sender.close();
        }
    }
}

