/*
 * Decompiled with CFR 0.152.
 */
package org.fluentd.logger.sender;

import java.io.IOException;
import java.util.Map;
import org.fluentd.logger.sender.Event;
import org.msgpack.MessageTypeException;
import org.msgpack.packer.Packer;
import org.msgpack.template.AbstractTemplate;
import org.msgpack.template.Templates;
import org.msgpack.unpacker.Unpacker;

public class EventTemplate
extends AbstractTemplate<Event> {
    public static EventTemplate INSTANCE = new EventTemplate();

    public void write(Packer pk, Event v, boolean required) throws IOException {
        if (v == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        pk.writeArrayBegin(3);
        Templates.TString.write(pk, (Object)v.tag, required);
        Templates.TLong.write(pk, (Object)v.timestamp, required);
        pk.writeMapBegin(v.data.size());
        for (Map.Entry<String, Object> entry : v.data.entrySet()) {
            Templates.TString.write(pk, (Object)entry.getKey(), required);
            try {
                pk.write(entry.getValue());
            }
            catch (MessageTypeException e) {
                String val = entry.getValue().toString();
                Templates.TString.write(pk, (Object)val, required);
            }
        }
        pk.writeMapEnd();
        pk.writeArrayEnd();
    }

    public Event read(Unpacker u, Event to, boolean required) throws IOException {
        throw new UnsupportedOperationException("Don't need the operation");
    }
}

