/*
 * Decompiled with CFR 0.152.
 */
package org.fluentd.logger.sender;

import java.util.LinkedList;
import java.util.logging.Logger;
import org.fluentd.logger.sender.Reconnector;

public class ExponentialDelayReconnector
implements Reconnector {
    private static final Logger LOG = Logger.getLogger(ExponentialDelayReconnector.class.getName());
    private double wait = 0.5;
    private double waitIncrRate = 1.5;
    private double waitMax = 60.0;
    private int waitMaxCount = this.getWaitMaxCount();
    private LinkedList<Long> errorHistory = new LinkedList();

    private int getWaitMaxCount() {
        double r = this.waitMax / this.wait;
        int j = 1;
        while (j <= 100) {
            if (r < this.waitIncrRate) {
                return j + 1;
            }
            r /= this.waitIncrRate;
            ++j;
        }
        return 100;
    }

    @Override
    public void addErrorHistory(long timestamp) {
        this.errorHistory.addLast(timestamp);
        if (this.errorHistory.size() > this.waitMaxCount) {
            this.errorHistory.removeFirst();
        }
    }

    @Override
    public void clearErrorHistory() {
        this.errorHistory.clear();
    }

    @Override
    public boolean enableReconnection(long timestamp) {
        int size = this.errorHistory.size();
        if (size == 0) {
            return true;
        }
        double suppressSec = size < this.waitMaxCount ? this.wait * Math.pow(this.waitIncrRate, size - 1) : this.waitMax;
        return !((double)(timestamp - this.errorHistory.getLast()) < suppressSec);
    }
}

