/*
 * Decompiled with CFR 0.152.
 */
package org.fluentd.logger.sender;

import java.util.LinkedList;
import org.fluentd.logger.sender.Reconnector;

public class ExponentialDelayReconnector
implements Reconnector {
    public static final double WAIT_MILLIS = 500.0;
    private static final double WAIT_INCR_RATE = 1.5;
    private static final double WAIT_MAX_MILLIS = 60000.0;
    private int waitMaxCount = this.getWaitMaxCount();
    private LinkedList<Long> errorHistory = new LinkedList();

    private int getWaitMaxCount() {
        double r = 120.0;
        for (int j = 1; j <= 100; ++j) {
            if (r < 1.5) {
                return j + 1;
            }
            r /= 1.5;
        }
        return 100;
    }

    @Override
    public void addErrorHistory(long timestamp) {
        this.errorHistory.addLast(timestamp);
        if (this.errorHistory.size() > this.waitMaxCount) {
            this.errorHistory.removeFirst();
        }
    }

    @Override
    public boolean isErrorHistoryEmpty() {
        return this.errorHistory.isEmpty();
    }

    @Override
    public void clearErrorHistory() {
        this.errorHistory.clear();
    }

    @Override
    public boolean enableReconnection(long timestamp) {
        int size = this.errorHistory.size();
        if (size == 0) {
            return true;
        }
        double suppressMillis = size < this.waitMaxCount ? 500.0 * Math.pow(1.5, size - 1) : 60000.0;
        return (double)(timestamp - this.errorHistory.getLast()) >= suppressMillis;
    }
}

