/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.adapter.junit.jupiter;

import java.lang.reflect.Method;
import java.util.Optional;
import org.fluentlenium.adapter.FluentTestRunnerAdapter;
import org.fluentlenium.adapter.junit.jupiter.FluentTest;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class FluentJUnitJupiter
implements BeforeEachCallback,
AfterEachCallback,
AfterAllCallback {
    public void beforeEach(ExtensionContext context) {
        FluentTest instance = this.testInstanceOf(context);
        instance._starting(this.testClassOf(context), this.testNameOf(context));
    }

    public void afterEach(ExtensionContext context) {
        FluentTest instance = this.testInstanceOf(context);
        Optional throwable = context.getExecutionException();
        if (throwable.isPresent()) {
            instance._failed((Throwable)throwable.get(), this.testClassOf(context), this.testNameOf(context));
        } else {
            instance._finished(this.testClassOf(context), this.testNameOf(context));
        }
    }

    public void afterAll(ExtensionContext context) {
        FluentTestRunnerAdapter.classDriverCleanup((Class)context.getTestClass().orElse(null));
    }

    private FluentTest testInstanceOf(ExtensionContext context) {
        try {
            return context.getTestInstance().orElse(null);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("FluentJUnitJupiter can not be used other than FluentTest class.", e);
        }
    }

    private Class testClassOf(ExtensionContext context) {
        return context.getTestClass().orElse(null);
    }

    private String testNameOf(ExtensionContext context) {
        return context.getTestMethod().map(Method::getName).orElse(null);
    }
}

