/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.adapter.junit.jupiter;

import java.lang.reflect.Parameter;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class MockitoExtension
implements TestInstancePostProcessor,
ParameterResolver {
    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        MockitoAnnotations.openMocks((Object)testInstance);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return parameterContext.getParameter().isAnnotationPresent(Mock.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return this.getMock(parameterContext.getParameter(), extensionContext);
    }

    private Object getMock(Parameter parameter, ExtensionContext extensionContext) {
        Class<?> mockType = parameter.getType();
        ExtensionContext.Store mocks = extensionContext.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{MockitoExtension.class, mockType}));
        String mockName = this.getMockName(parameter);
        if (mockName != null) {
            return mocks.getOrComputeIfAbsent((Object)mockName, key -> Mockito.mock((Class)mockType, (String)mockName));
        }
        return mocks.getOrComputeIfAbsent((Object)mockType.getCanonicalName(), key -> Mockito.mock((Class)mockType));
    }

    private String getMockName(Parameter parameter) {
        String explicitMockName = parameter.getAnnotation(Mock.class).name().trim();
        if (!explicitMockName.isEmpty()) {
            return explicitMockName;
        }
        if (parameter.isNamePresent()) {
            return parameter.getName();
        }
        return null;
    }
}

