/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.authentication.mysql;

import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.authentication.ExternalAuthFileReader;

public class MySQLOptionFileReader
implements ExternalAuthFileReader {
    private static final Log LOG = LogFactory.getLog(MySQLOptionFileReader.class);
    public final List<String> optionFiles = new ArrayList<String>();
    private final List<String> encryptedOptionFiles = new ArrayList<String>();

    public List<String> getAllContents() {
        ArrayList<String> fileContents = new ArrayList<String>();
        this.populateOptionFiles();
        for (String optionFile : this.optionFiles) {
            try {
                LOG.debug("Reading from MySQL option file '" + optionFile + "'.");
                if (this.encryptedOptionFiles.contains(optionFile)) {
                    FileInputStream optionFileIS = new FileInputStream(optionFile);
                    try {
                        fileContents.add(this.decryptFileContents(optionFileIS));
                        continue;
                    }
                    finally {
                        optionFileIS.close();
                        continue;
                    }
                }
                fileContents.add(new String(Files.readAllBytes(Paths.get(optionFile, new String[0]))));
            }
            catch (Exception e) {
                LOG.debug("Unable to read from MySQL option file '" + optionFile + "'.");
            }
        }
        return fileContents;
    }

    protected String decryptFileContents(FileInputStream reader) throws Exception {
        reader.skip(4L);
        byte[] rawKey = new byte[20];
        reader.read(rawKey, 0, 20);
        byte[] key = new byte[16];
        for (int i = 0; i < rawKey.length; ++i) {
            int n = i % 16;
            key[n] = (byte)(key[n] ^ rawKey[i]);
        }
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5PADDING");
        SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
        cipher.init(2, secretKey);
        byte[] chunkLength = new byte[4];
        StringBuilder stringBuilder = new StringBuilder();
        while (reader.read(chunkLength, 0, 4) == 4) {
            int len = ByteBuffer.wrap(chunkLength).order(ByteOrder.LITTLE_ENDIAN).getInt();
            byte[] chunk = new byte[len];
            reader.read(chunk, 0, len);
            stringBuilder.append(new String(cipher.doFinal(chunk)));
        }
        return stringBuilder.toString();
    }

    public void populateOptionFiles() {
        boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win");
        if (isWindows) {
            String winDir = System.getenv("WINDIR");
            this.addIfOptionFileExists(winDir + "\\my.ini", false);
            this.addIfOptionFileExists(winDir + "\\my.cnf", false);
            this.addIfOptionFileExists("C:\\my.ini", false);
            this.addIfOptionFileExists("C:\\my.cnf", false);
            String mysqlHome = System.getenv("MYSQL_HOME");
            if (mysqlHome != null) {
                this.addIfOptionFileExists(mysqlHome + "\\my.ini", false);
                this.addIfOptionFileExists(mysqlHome + "\\my.cnf", false);
            }
            String appdata = System.getenv("APPDATA");
            this.addIfOptionFileExists(appdata + "\\MySQL\\.mylogin.cnf", true);
        } else {
            this.addIfOptionFileExists("/etc/my.cnf", false);
            this.addIfOptionFileExists("/etc/mysql/my.cnf", false);
            String mysqlHome = System.getenv("MYSQL_HOME");
            if (mysqlHome != null) {
                this.addIfOptionFileExists(mysqlHome + "/my.cnf", false);
            }
            String userHome = System.getProperty("user.home");
            this.addIfOptionFileExists(userHome + "/.my.cnf", true);
            this.addIfOptionFileExists(userHome + "/.mylogin.cnf", true);
        }
    }

    private void addIfOptionFileExists(String optionFilePath, boolean encrypted) {
        File optionFile = new File(optionFilePath);
        if (!optionFile.exists()) {
            return;
        }
        this.optionFiles.add(optionFile.getAbsolutePath());
        if (encrypted) {
            this.encryptedOptionFiles.add(optionFile.getAbsolutePath());
        }
    }
}

