/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.output.InfoOutput;
import org.flywaydb.core.extensibility.RootTelemetryModel;
import org.flywaydb.core.extensibility.Tier;
import org.flywaydb.core.internal.configuration.models.ConfigurationModel;
import org.flywaydb.core.internal.license.EncryptionUtils;
import org.flywaydb.core.internal.license.FlywayPermit;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.util.StringUtils;

public class TelemetryUtils {
    private static final String NON_REDGATE_DOCKER = "Non-Redgate Docker";
    private static final String NON_REDGATE_CONTAINER = "Non-Redgate Container";
    private static final String UNKNOWN = "Unknown";
    private static final String NOT_CONTAINER = "Not container";
    private static final String REDGATE_DOCKER = "Redgate Docker";

    public static RootTelemetryModel populateRootTelemetry(RootTelemetryModel rootTelemetryModel, Configuration configuration, FlywayPermit flywayPermit) {
        ConfigurationModel modernConfig;
        boolean isRGDomainSet;
        rootTelemetryModel.setApplicationVersion(VersionPrinter.getVersion());
        boolean bl = isRGDomainSet = System.getenv("RGDOMAIN") != null;
        if (flywayPermit != null) {
            rootTelemetryModel.setRedgateEmployee(flywayPermit.isRedgateEmployee() || isRGDomainSet);
            rootTelemetryModel.setApplicationEdition(Tier.asString((Tier)flywayPermit.getTier()));
            rootTelemetryModel.setTrial(flywayPermit.isTrial());
            rootTelemetryModel.setSignedIn(flywayPermit.isFromAuth());
        } else {
            rootTelemetryModel.setRedgateEmployee(isRGDomainSet);
        }
        if (configuration != null && (modernConfig = configuration.getModernConfig()) != null && StringUtils.hasText((String)modernConfig.getId())) {
            rootTelemetryModel.setProjectId(EncryptionUtils.hashString((String)modernConfig.getId(), (String)"fur"));
        }
        rootTelemetryModel.setContainerType(TelemetryUtils.getContainerType(x$0 -> Paths.get(x$0, new String[0])));
        return rootTelemetryModel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getContainerType(Function<String, Path> getPath) {
        Path schedPath;
        String redgateDocker = System.getenv("REDGATE_DOCKER");
        if ("true".equals(redgateDocker)) {
            return REDGATE_DOCKER;
        }
        String osName = System.getProperty("os.name", "generic");
        if (osName.startsWith("Windows")) {
            return NOT_CONTAINER;
        }
        Path cgroupPath = getPath.apply("/proc/1/cgroup");
        if (Files.exists(cgroupPath, new LinkOption[0])) {
            try (Stream<String> lines = Files.lines(cgroupPath);){
                List<String> groups = lines.map(x -> x.split(":")[2]).toList();
                if (groups.stream().anyMatch(line -> line.startsWith("/docker"))) {
                    String string = NON_REDGATE_DOCKER;
                    return string;
                }
                if (groups.stream().anyMatch(line -> line.startsWith("/lxc"))) {
                    String string = NON_REDGATE_CONTAINER;
                    return string;
                }
            }
            catch (IOException e) {
                return UNKNOWN;
            }
        }
        if (!Files.exists(schedPath = getPath.apply("/proc/1/sched"), new LinkOption[0])) return UNKNOWN;
        try (Stream<String> lines = Files.lines(schedPath);){
            Optional<String> firstLine = lines.findFirst();
            if (!firstLine.isPresent()) return UNKNOWN;
            if (!firstLine.get().contains("init")) {
                if (!firstLine.get().contains("system")) return UNKNOWN;
            }
            String string = NOT_CONTAINER;
            return string;
        }
        catch (IOException e) {
            return UNKNOWN;
        }
    }

    public static String getOldestMigration(List<InfoOutput> infos) {
        if (infos == null) {
            return "";
        }
        ArrayList migrationDates = new ArrayList();
        infos.stream().filter(output -> StringUtils.hasText((String)output.installedOnUTC)).forEach(output -> migrationDates.add(output.installedOnUTC));
        if (!migrationDates.isEmpty()) {
            migrationDates.sort(Comparator.naturalOrder());
            return (String)migrationDates.get(0);
        }
        return "";
    }

    private TelemetryUtils() {
    }
}

