/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.callback;

import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.flywaydb.core.api.configuration.FlywayConfiguration;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.JdbcTemplate;
import org.flywaydb.core.internal.dbsupport.SqlScript;
import org.flywaydb.core.internal.util.Location;
import org.flywaydb.core.internal.util.Locations;
import org.flywaydb.core.internal.util.PlaceholderReplacer;
import org.flywaydb.core.internal.util.logging.Log;
import org.flywaydb.core.internal.util.logging.LogFactory;
import org.flywaydb.core.internal.util.scanner.Resource;
import org.flywaydb.core.internal.util.scanner.Scanner;

public class SqlScriptFlywayCallback
implements FlywayCallback {
    private static final Log LOG = LogFactory.getLog(SqlScriptFlywayCallback.class);
    private static final String BEFORE_CLEAN = "beforeClean";
    private static final String AFTER_CLEAN = "afterClean";
    private static final String BEFORE_MIGRATE = "beforeMigrate";
    private static final String AFTER_MIGRATE = "afterMigrate";
    private static final String BEFORE_EACH_MIGRATE = "beforeEachMigrate";
    private static final String AFTER_EACH_MIGRATE = "afterEachMigrate";
    private static final String BEFORE_VALIDATE = "beforeValidate";
    private static final String AFTER_VALIDATE = "afterValidate";
    private static final String BEFORE_BASELINE = "beforeBaseline";
    private static final String AFTER_BASELINE = "afterBaseline";
    private static final String BEFORE_REPAIR = "beforeRepair";
    private static final String AFTER_REPAIR = "afterRepair";
    private static final String BEFORE_INFO = "beforeInfo";
    private static final String AFTER_INFO = "afterInfo";
    public static final List<String> ALL_CALLBACKS = Arrays.asList("beforeClean", "afterClean", "beforeMigrate", "beforeEachMigrate", "afterEachMigrate", "afterMigrate", "beforeValidate", "afterValidate", "beforeBaseline", "afterBaseline", "beforeRepair", "afterRepair", "beforeInfo", "afterInfo");
    private final Map<String, SqlScript> scripts = new HashMap<String, SqlScript>();

    public SqlScriptFlywayCallback(DbSupport dbSupport, Scanner scanner, Locations locations, PlaceholderReplacer placeholderReplacer, FlywayConfiguration configuration) {
        for (String callback : ALL_CALLBACKS) {
            this.scripts.put(callback, null);
        }
        LOG.debug("Scanning for SQL callbacks ...");
        for (Location location : locations.getLocations()) {
            Resource[] resources;
            try {
                resources = scanner.scanForResources(location, "", configuration.getSqlMigrationSuffix());
            }
            catch (FlywayException e) {
                continue;
            }
            for (Resource resource : resources) {
                String key = resource.getFilename().replace(configuration.getSqlMigrationSuffix(), "");
                if (!this.scripts.keySet().contains(key)) continue;
                SqlScript existing = this.scripts.get(key);
                if (existing != null) {
                    throw new FlywayException("Found more than 1 SQL callback script for " + key + "!\n" + "Offenders:\n" + "-> " + existing.getResource().getLocationOnDisk() + "\n" + "-> " + resource.getLocationOnDisk());
                }
                this.scripts.put(key, new SqlScript(dbSupport, resource, placeholderReplacer, configuration.getEncoding(), configuration.isMixed()));
            }
        }
    }

    @Override
    public void beforeClean(Connection connection) {
        this.execute(BEFORE_CLEAN, connection);
    }

    @Override
    public void afterClean(Connection connection) {
        this.execute(AFTER_CLEAN, connection);
    }

    @Override
    public void beforeMigrate(Connection connection) {
        this.execute(BEFORE_MIGRATE, connection);
    }

    @Override
    public void afterMigrate(Connection connection) {
        this.execute(AFTER_MIGRATE, connection);
    }

    @Override
    public void beforeEachMigrate(Connection connection, MigrationInfo info) {
        this.execute(BEFORE_EACH_MIGRATE, connection);
    }

    @Override
    public void afterEachMigrate(Connection connection, MigrationInfo info) {
        this.execute(AFTER_EACH_MIGRATE, connection);
    }

    @Override
    public void beforeValidate(Connection connection) {
        this.execute(BEFORE_VALIDATE, connection);
    }

    @Override
    public void afterValidate(Connection connection) {
        this.execute(AFTER_VALIDATE, connection);
    }

    @Override
    public void beforeBaseline(Connection connection) {
        this.execute(BEFORE_BASELINE, connection);
    }

    @Override
    public void afterBaseline(Connection connection) {
        this.execute(AFTER_BASELINE, connection);
    }

    @Override
    public void beforeRepair(Connection connection) {
        this.execute(BEFORE_REPAIR, connection);
    }

    @Override
    public void afterRepair(Connection connection) {
        this.execute(AFTER_REPAIR, connection);
    }

    @Override
    public void beforeInfo(Connection connection) {
        this.execute(BEFORE_INFO, connection);
    }

    @Override
    public void afterInfo(Connection connection) {
        this.execute(AFTER_INFO, connection);
    }

    private void execute(String key, Connection connection) {
        SqlScript sqlScript = this.scripts.get(key);
        if (sqlScript != null) {
            LOG.info("Executing SQL callback: " + key);
            sqlScript.execute(new JdbcTemplate(connection, 0));
        }
    }
}

