/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.command;

import java.sql.Connection;
import java.util.concurrent.Callable;
import org.flywaydb.core.internal.dbsupport.Schema;
import org.flywaydb.core.internal.metadatatable.MetaDataTable;
import org.flywaydb.core.internal.util.jdbc.TransactionTemplate;
import org.flywaydb.core.internal.util.logging.Log;
import org.flywaydb.core.internal.util.logging.LogFactory;

public class DbSchemas {
    private static final Log LOG = LogFactory.getLog(DbSchemas.class);
    private final Connection connection;
    private final Schema[] schemas;
    private final MetaDataTable metaDataTable;

    public DbSchemas(Connection connection, Schema[] schemas, MetaDataTable metaDataTable) {
        this.connection = connection;
        this.schemas = schemas;
        this.metaDataTable = metaDataTable;
    }

    public void create() {
        int retries = 0;
        while (true) {
            try {
                new TransactionTemplate(this.connection).execute(new Callable<Object>(){

                    @Override
                    public Void call() {
                        for (Schema schema : DbSchemas.this.schemas) {
                            if (!schema.exists()) continue;
                            LOG.debug("Schema " + schema + " already exists. Skipping schema creation.");
                            return null;
                        }
                        for (Schema schema : DbSchemas.this.schemas) {
                            LOG.info("Creating schema " + schema + " ...");
                            schema.create();
                        }
                        DbSchemas.this.metaDataTable.addSchemasMarker(DbSchemas.this.schemas);
                        return null;
                    }
                });
                return;
            }
            catch (RuntimeException e) {
                if (++retries >= 10) {
                    throw e;
                }
                try {
                    LOG.debug("Schema creation failed. Retrying in 1 sec ...");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }
}

