/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource.internal;

import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import jdk.management.resource.ResourceAccuracy;
import jdk.management.resource.ResourceContext;
import jdk.management.resource.ResourceMeter;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceType;
import jdk.management.resource.internal.ApproverGroup;
import jdk.management.resource.internal.HeapMetrics;
import jdk.management.resource.internal.ResourceNatives;
import jdk.management.resource.internal.ThreadMetrics;
import jdk.management.resource.internal.TotalResourceContext;
import jdk.management.resource.internal.UnassignedContext;
import jdk.management.resource.internal.WeakKeyConcurrentHashMap;

public class SimpleResourceContext
implements ResourceContext {
    private final ConcurrentHashMap<ResourceType, ResourceMeter> meters = new ConcurrentHashMap();
    private static final WeakKeyConcurrentHashMap<Thread, ResourceContext> currContext = new WeakKeyConcurrentHashMap();
    private static final ConcurrentHashMap<String, SimpleResourceContext> contexts = new ConcurrentHashMap();
    private final String name;
    private final int contextId;
    private volatile boolean closed;

    SimpleResourceContext(String string) {
        this(Objects.requireNonNull(string, "name"), ResourceNatives.isHeapRetainedEnabled() ? ResourceNatives.createResourceContext() : 0);
    }

    SimpleResourceContext(String string, int n) {
        this.name = Objects.requireNonNull(string, "name");
        this.contextId = n;
        this.closed = false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static ResourceContext create(String string) {
        if (!contexts.containsKey(string)) {
            SimpleResourceContext simpleResourceContext = new SimpleResourceContext(string);
            ResourceContext resourceContext = contexts.putIfAbsent(string, simpleResourceContext);
            if (resourceContext == null) {
                return simpleResourceContext;
            }
            if (ResourceNatives.isHeapRetainedEnabled()) {
                ResourceNatives.destroyResourceContext(simpleResourceContext.contextId, 0);
            }
        }
        throw new IllegalArgumentException("ResourceContext already exists for name: " + string);
    }

    public static ResourceContext get(String string) {
        Objects.requireNonNull(string, "name");
        return contexts.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        SimpleResourceContext simpleResourceContext = this;
        synchronized (simpleResourceContext) {
            if (!this.closed) {
                this.closed = true;
                contexts.remove(this.getName());
                UnassignedContext unassignedContext = UnassignedContext.getUnassignedContext();
                if (ResourceNatives.isHeapRetainedEnabled()) {
                    ResourceNatives.destroyResourceContext(this.contextId, unassignedContext.nativeThreadContext());
                }
                this.boundThreads().forEach(thread -> unassignedContext.bindThreadContext((Thread)thread));
                this.meters.forEach((resourceType, resourceMeter) -> {
                    this.removeResourceMeter((ResourceMeter)resourceMeter);
                    ApproverGroup approverGroup = ApproverGroup.getGroup(resourceType);
                    if (approverGroup != null) {
                        approverGroup.purgeResourceContext(this);
                    }
                });
            }
        }
    }

    static ConcurrentHashMap<String, SimpleResourceContext> getContexts() {
        return contexts;
    }

    public static Stream<ResourceContext> contexts() {
        return SimpleResourceContext.getContexts().values().stream().map(simpleResourceContext -> simpleResourceContext);
    }

    public static ResourceContext getThreadContext(Thread thread) {
        ResourceContext resourceContext = currContext.get(thread);
        if (resourceContext == null) {
            resourceContext = UnassignedContext.getUnassignedContext();
        }
        return resourceContext;
    }

    @Override
    public ResourceContext bindThreadContext() {
        this.illegalStateIfClosed();
        Thread thread = Thread.currentThread();
        ResourceContext resourceContext = currContext.put(thread, this);
        if (resourceContext == null) {
            resourceContext = UnassignedContext.getUnassignedContext();
        }
        ThreadMetrics.updateCurrentThreadMetrics(resourceContext);
        if (ResourceNatives.isHeapRetainedEnabled()) {
            ResourceNatives.setThreadResourceContext(this.contextId);
        }
        return resourceContext;
    }

    public ResourceContext bindThreadContext(Thread thread) {
        ResourceContext resourceContext;
        this.illegalStateIfClosed();
        ResourceContext resourceContext2 = resourceContext = thread.isAlive() ? currContext.put(thread, this) : currContext.remove(thread);
        if (resourceContext == null) {
            resourceContext = UnassignedContext.getUnassignedContext();
        }
        try {
            ThreadMetrics.updateThreadMetrics(resourceContext, thread);
            if (ResourceNatives.isHeapRetainedEnabled()) {
                ResourceNatives.setThreadResourceContext(thread.getId(), this.contextId);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            currContext.remove(thread);
        }
        return resourceContext;
    }

    public void bindNewThreadContext(Thread thread) {
        currContext.put(thread, this);
    }

    public static void removeThreadContext() {
        currContext.remove(Thread.currentThread());
    }

    public static ResourceContext unbindThreadContext() {
        return UnassignedContext.getUnassignedContext().bindThreadContext();
    }

    int nativeThreadContext() {
        return this.contextId;
    }

    @Override
    public Stream<Thread> boundThreads() {
        return currContext.keysForValue(this).filter(thread -> thread.isAlive());
    }

    @Override
    public ResourceRequest getResourceRequest(ResourceType resourceType) {
        ResourceMeter resourceMeter = this.meters.get(resourceType);
        return resourceMeter instanceof ResourceRequest ? (ResourceRequest)((Object)resourceMeter) : null;
    }

    @Override
    public void addResourceMeter(ResourceMeter resourceMeter) {
        this.illegalStateIfClosed();
        if (resourceMeter.getType().equals(ResourceType.HEAP_RETAINED) && !ResourceNatives.isHeapRetainedEnabled()) {
            throw new UnsupportedOperationException("ResourceType not supported by the current garbage collector: " + ResourceType.HEAP_RETAINED);
        }
        ResourceMeter resourceMeter2 = this.meters.putIfAbsent(resourceMeter.getType(), resourceMeter);
        if (resourceMeter2 != null) {
            throw new IllegalArgumentException("ResourceType already added to meter: " + resourceMeter.getType().getName());
        }
        if (resourceMeter.getType().equals(ResourceType.THREAD_CPU) || resourceMeter.getType().equals(ResourceType.HEAP_ALLOCATED)) {
            ThreadMetrics.init();
        }
        if (resourceMeter.getType().equals(ResourceType.HEAP_RETAINED)) {
            HeapMetrics.init();
        }
        TotalResourceContext.validateMeter(resourceMeter.getType());
    }

    @Override
    public boolean removeResourceMeter(ResourceMeter resourceMeter) {
        ResourceMeter resourceMeter2 = this.meters.remove(resourceMeter.getType());
        if (resourceMeter2 != null) {
            TotalResourceContext totalResourceContext = TotalResourceContext.getTotalContext();
            TotalResourceContext.TotalMeter totalMeter = totalResourceContext.getMeter(resourceMeter2.getType());
            totalMeter.addValue(resourceMeter2.getValue());
            totalMeter.addAllocated(resourceMeter2.getAllocated());
            return true;
        }
        return false;
    }

    @Override
    public ResourceMeter getMeter(ResourceType resourceType) {
        return this.meters.get(resourceType);
    }

    @Override
    public Stream<ResourceMeter> meters() {
        return this.meters.entrySet().stream().map(entry -> (ResourceMeter)entry.getValue());
    }

    @Override
    public void requestAccurateUpdate(ResourceAccuracy resourceAccuracy) {
        Objects.requireNonNull(resourceAccuracy, "accuracy");
        if (!ResourceNatives.isHeapRetainedEnabled()) {
            throw new UnsupportedOperationException("ResourceType not supported by the current garbage collector: " + ResourceType.HEAP_RETAINED);
        }
        int[] nArray = new int[]{this.contextId};
        ResourceNatives.computeRetainedMemory(nArray, resourceAccuracy.ordinal());
    }

    private synchronized void illegalStateIfClosed() {
        if (this.closed) {
            throw new IllegalStateException("ResourceContext is closed: " + this.getName());
        }
    }

    public String toString() {
        StringJoiner stringJoiner = new StringJoiner("; ", this.name + "[", "]");
        this.meters.forEach((resourceType, resourceMeter) -> stringJoiner.add(resourceMeter.toString()));
        return stringJoiner.toString();
    }
}

