/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.callback;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.callback.Context;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.resource.ResourceProvider;
import org.flywaydb.core.internal.sqlscript.SqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutorFactory;
import org.flywaydb.core.internal.sqlscript.SqlScriptFactory;

public class SqlScriptCallbackFactory {
    private static final Log LOG = LogFactory.getLog(SqlScriptCallbackFactory.class);
    private final List<SqlScriptCallback> callbacks = new ArrayList<SqlScriptCallback>();

    public SqlScriptCallbackFactory(ResourceProvider resourceProvider, SqlScriptExecutorFactory sqlScriptExecutorFactory, SqlScriptFactory sqlScriptFactory, Configuration configuration) {
        HashMap<String, SqlScript> callbacksFound = new HashMap<String, SqlScript>();
        LOG.debug("Scanning for SQL callbacks ...");
        Collection<LoadableResource> resources = resourceProvider.getResources("", configuration.getSqlMigrationSuffixes());
        for (LoadableResource resource : resources) {
            Event event;
            String description;
            String id;
            String name = this.stripSuffix(resource.getFilename(), configuration.getSqlMigrationSuffixes());
            int separatorIndex = name.indexOf(configuration.getSqlMigrationSeparator());
            if (separatorIndex >= 0) {
                id = name.substring(0, separatorIndex);
                description = name.substring(separatorIndex + configuration.getSqlMigrationSeparator().length());
            } else {
                id = name;
                description = null;
            }
            if ((event = Event.fromId(id)) == null) continue;
            SqlScript existing = (SqlScript)callbacksFound.get(name);
            if (existing != null) {
                throw new FlywayException("Found more than 1 SQL callback script called " + name + "!\nOffenders:\n-> " + existing.getResource().getAbsolutePathOnDisk() + "\n-> " + resource.getAbsolutePathOnDisk());
            }
            SqlScript sqlScript = sqlScriptFactory.createSqlScript(resource, configuration.isMixed(), resourceProvider);
            callbacksFound.put(name, sqlScript);
            this.callbacks.add(new SqlScriptCallback(event, description, sqlScriptExecutorFactory, sqlScript, configuration.isBatch()));
        }
        Collections.sort(this.callbacks);
    }

    public List<Callback> getCallbacks() {
        return new ArrayList<Callback>(this.callbacks);
    }

    private String stripSuffix(String fileName, String[] suffixes) {
        for (String suffix : suffixes) {
            if (!fileName.endsWith(suffix)) continue;
            return fileName.substring(0, fileName.length() - suffix.length());
        }
        return fileName;
    }

    private static class SqlScriptCallback
    implements Callback,
    Comparable<SqlScriptCallback> {
        private final Event event;
        private final String description;
        private final SqlScriptExecutorFactory sqlScriptExecutorFactory;
        private final SqlScript sqlScript;
        private final boolean batch;

        private SqlScriptCallback(Event event, String description, SqlScriptExecutorFactory sqlScriptExecutorFactory, SqlScript sqlScript, boolean batch) {
            this.event = event;
            this.description = description;
            this.sqlScriptExecutorFactory = sqlScriptExecutorFactory;
            this.sqlScript = sqlScript;
            this.batch = batch;
        }

        @Override
        public boolean supports(Event event, Context context) {
            return this.event == event;
        }

        @Override
        public boolean canHandleInTransaction(Event event, Context context) {
            return this.sqlScript.executeInTransaction();
        }

        @Override
        public void handle(Event event, Context context) {
            LOG.info("Executing SQL callback: " + event.getId() + (this.description == null ? "" : " - " + this.description) + (this.sqlScript.executeInTransaction() ? "" : " [non-transactional]"));
            this.sqlScriptExecutorFactory.createSqlScriptExecutor(context.getConnection(), false, this.batch, context.getConfiguration().outputQueryResults()).execute(this.sqlScript);
        }

        @Override
        public int compareTo(SqlScriptCallback o) {
            int result = this.event.compareTo(o.event);
            if (result == 0) {
                if (this.description == null) {
                    return Integer.MIN_VALUE;
                }
                if (o.description == null) {
                    return Integer.MAX_VALUE;
                }
                result = this.description.compareTo(o.description);
            }
            return result;
        }
    }
}

