/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database;

import java.sql.Connection;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBDatabase;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBParser;
import org.flywaydb.core.internal.database.db2.DB2Database;
import org.flywaydb.core.internal.database.db2.DB2Parser;
import org.flywaydb.core.internal.database.derby.DerbyDatabase;
import org.flywaydb.core.internal.database.derby.DerbyParser;
import org.flywaydb.core.internal.database.firebird.FirebirdDatabase;
import org.flywaydb.core.internal.database.firebird.FirebirdParser;
import org.flywaydb.core.internal.database.h2.H2Database;
import org.flywaydb.core.internal.database.h2.H2Parser;
import org.flywaydb.core.internal.database.hsqldb.HSQLDBDatabase;
import org.flywaydb.core.internal.database.hsqldb.HSQLDBParser;
import org.flywaydb.core.internal.database.informix.InformixDatabase;
import org.flywaydb.core.internal.database.informix.InformixParser;
import org.flywaydb.core.internal.database.mysql.MySQLDatabase;
import org.flywaydb.core.internal.database.mysql.MySQLParser;
import org.flywaydb.core.internal.database.oracle.OracleDatabase;
import org.flywaydb.core.internal.database.oracle.OracleParser;
import org.flywaydb.core.internal.database.oracle.OracleSqlScriptExecutor;
import org.flywaydb.core.internal.database.oracle.pro.SQLPlusPlaceholderProvider;
import org.flywaydb.core.internal.database.postgresql.PostgreSQLDatabase;
import org.flywaydb.core.internal.database.postgresql.PostgreSQLParser;
import org.flywaydb.core.internal.database.redshift.RedshiftDatabase;
import org.flywaydb.core.internal.database.redshift.RedshiftParser;
import org.flywaydb.core.internal.database.saphana.SAPHANADatabase;
import org.flywaydb.core.internal.database.saphana.SAPHANAParser;
import org.flywaydb.core.internal.database.sqlite.SQLiteDatabase;
import org.flywaydb.core.internal.database.sqlite.SQLiteParser;
import org.flywaydb.core.internal.database.sqlserver.SQLServerDatabase;
import org.flywaydb.core.internal.database.sqlserver.SQLServerParser;
import org.flywaydb.core.internal.database.sybasease.SybaseASEDatabase;
import org.flywaydb.core.internal.database.sybasease.SybaseASEParser;
import org.flywaydb.core.internal.jdbc.DatabaseType;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.pro.DryRunStatementInterceptor;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.resource.ResourceProvider;
import org.flywaydb.core.internal.sqlscript.DefaultSqlScriptExecutor;
import org.flywaydb.core.internal.sqlscript.ParserSqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutor;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutorFactory;
import org.flywaydb.core.internal.sqlscript.SqlScriptFactory;

public class DatabaseFactory {
    private static final Log LOG = LogFactory.getLog(DatabaseFactory.class);

    private DatabaseFactory() {
    }

    public static Database createDatabase(Configuration configuration, boolean printInfo, JdbcConnectionFactory jdbcConnectionFactory, DryRunStatementInterceptor dryRunStatementInterceptor) {
        DatabaseType databaseType;
        Database database;
        OracleDatabase.enableTnsnamesOraSupport();
        String databaseProductName = jdbcConnectionFactory.getProductName();
        if (printInfo) {
            LOG.info("Database: " + jdbcConnectionFactory.getJdbcUrl() + " (" + databaseProductName + ")");
            LOG.debug("Driver  : " + jdbcConnectionFactory.getDriverInfo());
        }
        if (!(database = DatabaseFactory.createDatabase(databaseType = jdbcConnectionFactory.getDatabaseType(), configuration, jdbcConnectionFactory, dryRunStatementInterceptor)).supportsChangingCurrentSchema() && configuration.getSchemas().length > 0) {
            LOG.warn(databaseProductName + " does not support setting the schema for the current session. Default schema will NOT be changed to " + configuration.getSchemas()[0] + " !");
        }
        return database;
    }

    private static Database createDatabase(DatabaseType databaseType, Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, DryRunStatementInterceptor dryRunStatementInterceptor) {
        switch (databaseType) {
            case COCKROACHDB: {
                return new CockroachDBDatabase(configuration, jdbcConnectionFactory, dryRunStatementInterceptor);
            }
            case DB2: {
                return new DB2Database(configuration, jdbcConnectionFactory, dryRunStatementInterceptor);
            }
            case DERBY: {
                return new DerbyDatabase(configuration, jdbcConnectionFactory, dryRunStatementInterceptor);
            }
            case FIREBIRD: {
                return new FirebirdDatabase(configuration, jdbcConnectionFactory, dryRunStatementInterceptor);
            }
            case H2: {
                return new H2Database(configuration, jdbcConnectionFactory, dryRunStatementInterceptor);
            }
            case HSQLDB: {
                return new HSQLDBDatabase(configuration, jdbcConnectionFactory, dryRunStatementInterceptor);
            }
            case INFORMIX: {
                return new InformixDatabase(configuration, jdbcConnectionFactory, dryRunStatementInterceptor);
            }
            case MARIADB: 
            case MYSQL: {
                return new MySQLDatabase(configuration, jdbcConnectionFactory, dryRunStatementInterceptor);
            }
            case ORACLE: {
                return new OracleDatabase(configuration, jdbcConnectionFactory, dryRunStatementInterceptor);
            }
            case POSTGRESQL: {
                return new PostgreSQLDatabase(configuration, jdbcConnectionFactory, dryRunStatementInterceptor);
            }
            case REDSHIFT: {
                return new RedshiftDatabase(configuration, jdbcConnectionFactory, dryRunStatementInterceptor);
            }
            case SQLITE: {
                return new SQLiteDatabase(configuration, jdbcConnectionFactory, dryRunStatementInterceptor);
            }
            case SAPHANA: {
                return new SAPHANADatabase(configuration, jdbcConnectionFactory, dryRunStatementInterceptor);
            }
            case SQLSERVER: {
                return new SQLServerDatabase(configuration, jdbcConnectionFactory, dryRunStatementInterceptor);
            }
            case SYBASEASE_JCONNECT: 
            case SYBASEASE_JTDS: {
                return new SybaseASEDatabase(configuration, jdbcConnectionFactory, dryRunStatementInterceptor);
            }
        }
        throw new FlywayException("Unsupported Database: " + databaseType.name());
    }

    public static SqlScriptFactory createSqlScriptFactory(final JdbcConnectionFactory jdbcConnectionFactory, final Configuration configuration) {
        DatabaseType databaseType = jdbcConnectionFactory.getDatabaseType();
        return new SqlScriptFactory(){

            @Override
            public SqlScript createSqlScript(LoadableResource resource, boolean mixed, ResourceProvider resourceProvider) {
                return new ParserSqlScript(DatabaseFactory.createParser(jdbcConnectionFactory, configuration, resourceProvider), resource, mixed);
            }
        };
    }

    private static Parser createParser(JdbcConnectionFactory jdbcConnectionFactory, Configuration configuration, ResourceProvider resourceProvider) {
        DatabaseType databaseType = jdbcConnectionFactory.getDatabaseType();
        switch (databaseType) {
            case COCKROACHDB: {
                return new CockroachDBParser(configuration);
            }
            case DB2: {
                return new DB2Parser(configuration);
            }
            case DERBY: {
                return new DerbyParser(configuration);
            }
            case FIREBIRD: {
                return new FirebirdParser(configuration);
            }
            case H2: {
                return new H2Parser(configuration);
            }
            case HSQLDB: {
                return new HSQLDBParser(configuration);
            }
            case INFORMIX: {
                return new InformixParser(configuration);
            }
            case MARIADB: 
            case MYSQL: {
                return new MySQLParser(configuration);
            }
            case ORACLE: {
                return new OracleParser(configuration, configuration.isOracleSqlplus(), configuration.isOracleSqlplusWarn(), new SQLPlusPlaceholderProvider(configuration.getPlaceholders(), jdbcConnectionFactory.getOracleUser(), jdbcConnectionFactory.getOracleConnectIdentifier(), jdbcConnectionFactory.getOracleORelease(), jdbcConnectionFactory.getOracleOVersion()), resourceProvider);
            }
            case POSTGRESQL: {
                return new PostgreSQLParser(configuration);
            }
            case REDSHIFT: {
                return new RedshiftParser(configuration);
            }
            case SQLITE: {
                return new SQLiteParser(configuration);
            }
            case SAPHANA: {
                return new SAPHANAParser(configuration);
            }
            case SQLSERVER: {
                return new SQLServerParser(configuration);
            }
            case SYBASEASE_JCONNECT: 
            case SYBASEASE_JTDS: {
                return new SybaseASEParser(configuration);
            }
        }
        throw new FlywayException("Unsupported Database: " + databaseType.name());
    }

    public static SqlScriptExecutorFactory createSqlScriptExecutorFactory(JdbcConnectionFactory jdbcConnectionFactory, final CallbackExecutor callbackExecutor, final DryRunStatementInterceptor dryRunStatementInterceptor) {
        final DatabaseType databaseType = jdbcConnectionFactory.getDatabaseType();
        final boolean supportsBatch = jdbcConnectionFactory.isSupportsBatch();
        if (DatabaseType.ORACLE == databaseType) {
            return new SqlScriptExecutorFactory(){

                @Override
                public SqlScriptExecutor createSqlScriptExecutor(Connection connection, boolean undo, boolean batch, boolean outputQueryResults) {
                    return new OracleSqlScriptExecutor(new JdbcTemplate(connection, databaseType), callbackExecutor, undo, supportsBatch && batch, outputQueryResults, dryRunStatementInterceptor);
                }
            };
        }
        return new SqlScriptExecutorFactory(){

            @Override
            public SqlScriptExecutor createSqlScriptExecutor(Connection connection, boolean undo, boolean batch, boolean outputQueryResults) {
                return new DefaultSqlScriptExecutor(new JdbcTemplate(connection, databaseType), callbackExecutor, undo, supportsBatch && batch, outputQueryResults, dryRunStatementInterceptor);
            }
        };
    }
}

