/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.sybasease;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.sybasease.SybaseASEConnection;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.pro.DryRunStatementInterceptor;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.core.internal.sqlscript.Delimiter;

public class SybaseASEDatabase
extends Database<SybaseASEConnection> {
    public SybaseASEDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, DryRunStatementInterceptor dryRunStatementInterceptor) {
        super(configuration, jdbcConnectionFactory, dryRunStatementInterceptor);
    }

    @Override
    protected SybaseASEConnection doGetConnection(Connection connection) {
        return new SybaseASEConnection(this, connection);
    }

    @Override
    public void ensureSupported() {
        this.ensureDatabaseIsRecentEnough("15.7");
        this.ensureDatabaseNotOlderThanOtherwiseRecommendUpgradeToFlywayEdition("16.0", Edition.ENTERPRISE);
        this.recommendFlywayUpgradeIfNecessary("16.2");
    }

    @Override
    public String getRawCreateScript(Table table, boolean baseline) {
        return "CREATE TABLE " + table.getName() + " (\n    installed_rank INT NOT NULL,\n    version VARCHAR(50) NULL,\n    description VARCHAR(200) NOT NULL,\n    type VARCHAR(20) NOT NULL,\n    script VARCHAR(1000) NOT NULL,\n    checksum INT NULL,\n    installed_by VARCHAR(100) NOT NULL,\n    installed_on datetime DEFAULT getDate() NOT NULL,\n    execution_time INT NOT NULL,\n    success decimal NOT NULL,\n    PRIMARY KEY (installed_rank)\n)\nlock datarows on 'default'\n" + (baseline ? this.getBaselineStatement(table) + "\n" : "") + "go\nCREATE INDEX " + table.getName() + "_s_idx ON " + table.getName() + " (success)\ngo\n";
    }

    @Override
    public Delimiter getDefaultDelimiter() {
        return Delimiter.GO;
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return ((SybaseASEConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT user_name()", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    protected String doQuote(String identifier) {
        return identifier;
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }
}

