/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.license;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.core.internal.license.pro.LicenseInfo;
import org.flywaydb.core.internal.license.pro.LicenseType;
import org.flywaydb.core.internal.util.DateUtils;
import org.flywaydb.core.internal.util.FileCopyUtils;

public class VersionPrinter {
    private static final Log LOG = LogFactory.getLog(VersionPrinter.class);
    private static final String version = VersionPrinter.readVersion();
    private static boolean printed;
    public static final Edition EDITION;

    private VersionPrinter() {
    }

    public static void printVersion(String licenseKey) {
        if (printed) {
            return;
        }
        printed = true;
        VersionPrinter.printLicenseInfo(licenseKey);
    }

    public static void printVersionOnly() {
        LOG.info((Object)((Object)EDITION) + " " + version + " by Boxfuse");
    }

    private static void printLicenseInfo(String licenseKey) {
        LicenseInfo licenseInfo = new LicenseInfo(licenseKey);
        LicenseType licenseType = licenseInfo.getLicenseType();
        if (licenseType.getEdition() != EDITION) {
            VersionPrinter.printVersionOnly();
            throw new FlywayException("Your license key is incompatible with " + (Object)((Object)EDITION) + ". Download " + (Object)((Object)licenseType.getEdition()) + " instead.");
        }
        LOG.info((Object)((Object)licenseType) + " " + version + " by Boxfuse" + " licensed to " + licenseInfo.getLicensedTo() + " until " + DateUtils.toDateString(licenseInfo.getValidUntil()));
        if (licenseInfo.getValidUntil().before(new Date())) {
            if (licenseType == LicenseType.TRIAL) {
                LOG.error("Your 30 day limited Flyway trial license has expired and is no longer valid. You must upgrade to a full " + (Object)((Object)EDITION) + " license immediately to keep on using this software.");
            } else {
                LOG.error("Your " + (Object)((Object)EDITION) + " license has expired and is no longer valid. You must renew your license immediately to keep on using this software.");
            }
        } else if (licenseType == LicenseType.TRIAL) {
            LOG.warn("You are using a 30 day limited Flyway trial license. After 30 days you must either upgrade to a full " + (Object)((Object)EDITION) + " license or downgrade to " + (Object)((Object)Edition.COMMUNITY) + ".");
        }
    }

    private static String readVersion() {
        try {
            return FileCopyUtils.copyToString(VersionPrinter.class.getClassLoader().getResourceAsStream("org/flywaydb/core/internal/version.txt"), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new FlywayException("Unable to read Flyway version: " + e.getMessage(), e);
        }
    }

    static {
        EDITION = Edition.PRO;
    }
}

