/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resolver.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.zip.CRC32;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.resolver.Context;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.resolver.MigrationInfoHelper;
import org.flywaydb.core.internal.resolver.ResolvedMigrationComparator;
import org.flywaydb.core.internal.resolver.ResolvedMigrationImpl;
import org.flywaydb.core.internal.resolver.sql.SqlMigrationExecutor;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.resource.ResourceProvider;
import org.flywaydb.core.internal.sqlscript.SqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutorFactory;
import org.flywaydb.core.internal.sqlscript.SqlScriptFactory;
import org.flywaydb.core.internal.util.Pair;

public class SqlMigrationResolver
implements MigrationResolver {
    private final SqlScriptExecutorFactory sqlScriptExecutorFactory;
    private final ResourceProvider resourceProvider;
    private final SqlScriptFactory sqlScriptFactory;
    private final Configuration configuration;

    public SqlMigrationResolver(ResourceProvider resourceProvider, SqlScriptExecutorFactory sqlScriptExecutorFactory, SqlScriptFactory sqlScriptFactory, Configuration configuration) {
        this.sqlScriptExecutorFactory = sqlScriptExecutorFactory;
        this.resourceProvider = resourceProvider;
        this.sqlScriptFactory = sqlScriptFactory;
        this.configuration = configuration;
    }

    public List<ResolvedMigration> resolveMigrations(Context context) {
        ArrayList<ResolvedMigration> migrations = new ArrayList<ResolvedMigration>();
        String separator = this.configuration.getSqlMigrationSeparator();
        String[] suffixes = this.configuration.getSqlMigrationSuffixes();
        this.addMigrations(migrations, this.configuration.getSqlMigrationPrefix(), separator, suffixes, false, false);
        this.addMigrations(migrations, this.configuration.getUndoSqlMigrationPrefix(), separator, suffixes, false, true);
        this.addMigrations(migrations, this.configuration.getRepeatableSqlMigrationPrefix(), separator, suffixes, true, false);
        Collections.sort(migrations, new ResolvedMigrationComparator());
        return migrations;
    }

    private void addMigrations(List<ResolvedMigration> migrations, String prefix, String separator, String[] suffixes, boolean repeatable, boolean undo) {
        for (LoadableResource resource : this.resourceProvider.getResources(prefix, suffixes)) {
            int checksum;
            String filename = resource.getFilename();
            if (SqlMigrationResolver.isSqlCallback(filename, separator, suffixes)) continue;
            SqlScript sqlScript = this.sqlScriptFactory.createSqlScript(resource, this.configuration.isMixed(), this.resourceProvider);
            ArrayList<LoadableResource> resources = new ArrayList<LoadableResource>();
            resources.add(resource);
            TreeSet<LoadableResource> referencedResources = new TreeSet<LoadableResource>();
            for (SqlScript referencedSqlScript : sqlScript.getReferencedSqlScripts()) {
                referencedResources.add(referencedSqlScript.getResource());
            }
            resources.addAll(referencedResources);
            if (resources.size() == 1) {
                checksum = resource.checksum();
            } else {
                CRC32 crc32 = new CRC32();
                for (LoadableResource r : resources) {
                    crc32.update(SqlMigrationResolver.intToByteArray(r.checksum()));
                }
                checksum = (int)crc32.getValue();
            }
            Pair<MigrationVersion, String> info = MigrationInfoHelper.extractVersionAndDescription(filename, prefix, separator, suffixes, repeatable);
            migrations.add(new ResolvedMigrationImpl(info.getLeft(), info.getRight(), resource.getRelativePath(), checksum, undo ? MigrationType.UNDO_SQL : MigrationType.SQL, resource.getAbsolutePathOnDisk(), new SqlMigrationExecutor(this.sqlScriptExecutorFactory, sqlScript, undo, this.configuration.isBatch())){

                @Override
                public void validate() {
                }
            });
        }
    }

    private static byte[] intToByteArray(int i) {
        return new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
    }

    static boolean isSqlCallback(String filename, String separator, String ... suffixes) {
        for (String suffix : suffixes) {
            String baseName = filename.substring(0, filename.length() - suffix.length());
            int index = baseName.indexOf(separator);
            if (index >= 0) {
                baseName = baseName.substring(0, index);
            }
            if (Event.fromId(baseName) == null) continue;
            return true;
        }
        return false;
    }
}

