/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resource.filesystem;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.StandardOpenOption;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.internal.resource.LoadableResource;

public class FileSystemResource
extends LoadableResource {
    private static final long STREAM_MINIMUM_THRESHOLD = 0x100000L;
    private final File file;
    private final String relativePath;
    private final Charset encoding;
    private final boolean stream;

    public FileSystemResource(Location location, String fileNameWithPath, Charset encoding, boolean stream) {
        this.file = new File(new File(fileNameWithPath).getPath());
        this.relativePath = (location == null || location.getPath().isEmpty() ? this.file.getPath() : this.file.getAbsolutePath().substring(new File(location.getPath()).getAbsolutePath().length() + 1)).replace("\\", "/");
        this.encoding = encoding;
        this.stream = stream;
    }

    @Override
    public String getAbsolutePath() {
        return this.file.getPath();
    }

    @Override
    public String getAbsolutePathOnDisk() {
        return this.file.getAbsolutePath();
    }

    @Override
    public Reader read() {
        try {
            return Channels.newReader(FileChannel.open(this.file.toPath(), StandardOpenOption.READ), this.encoding.newDecoder(), 4096);
        }
        catch (IOException e) {
            throw new FlywayException("Unable to load filesystem resource: " + this.file.getPath() + " (encoding: " + this.encoding + ")", e);
        }
    }

    @Override
    public boolean shouldStream() {
        return this.stream && this.file.length() > 0x100000L;
    }

    @Override
    public String getFilename() {
        return this.file.getName();
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }
}

