/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.scanner;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.clazz.ClassProvider;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.resource.ResourceProvider;
import org.flywaydb.core.internal.scanner.android.AndroidScanner;
import org.flywaydb.core.internal.scanner.classpath.ClassPathScanner;
import org.flywaydb.core.internal.scanner.classpath.ResourceAndClassScanner;
import org.flywaydb.core.internal.scanner.filesystem.FileSystemScanner;
import org.flywaydb.core.internal.util.FeatureDetector;
import org.flywaydb.core.internal.util.StringUtils;

public class Scanner
implements ResourceProvider,
ClassProvider {
    private static final Log LOG = LogFactory.getLog(Scanner.class);
    private final List<LoadableResource> resources = new ArrayList<LoadableResource>();
    private final List<Class<?>> classes = new ArrayList();

    public Scanner(Collection<Location> locations, ClassLoader classLoader, Charset encoding, boolean stream) {
        FileSystemScanner fileSystemScanner = new FileSystemScanner(encoding, stream);
        boolean android = new FeatureDetector(classLoader).isAndroidAvailable();
        for (Location location : locations) {
            if (location.isFileSystem()) {
                this.resources.addAll(fileSystemScanner.scanForResources(location));
                continue;
            }
            ResourceAndClassScanner resourceAndClassScanner = android ? new AndroidScanner(classLoader, encoding, location) : new ClassPathScanner(classLoader, encoding, location);
            this.resources.addAll(resourceAndClassScanner.scanForResources());
            this.classes.addAll(resourceAndClassScanner.scanForClasses());
        }
    }

    @Override
    public LoadableResource getResource(String name) {
        for (LoadableResource resource : this.resources) {
            String fileName = resource.getRelativePath();
            if (!fileName.equals(name)) continue;
            return resource;
        }
        return null;
    }

    @Override
    public Collection<LoadableResource> getResources(String prefix, String ... suffixes) {
        ArrayList<LoadableResource> result = new ArrayList<LoadableResource>();
        for (LoadableResource resource : this.resources) {
            String fileName = resource.getFilename();
            if (StringUtils.startsAndEndsWith(fileName, prefix, suffixes)) {
                result.add(resource);
                continue;
            }
            LOG.debug("Filtering out resource: " + resource.getAbsolutePath() + " (filename: " + fileName + ")");
        }
        return result;
    }

    @Override
    public <I> Collection<Class<? extends I>> getClasses(Class<I> implementedInterface) {
        ArrayList<Class<I>> result = new ArrayList<Class<I>>();
        for (Class<?> clazz : this.classes) {
            if (!implementedInterface.isAssignableFrom(clazz)) continue;
            result.add(clazz);
        }
        return result;
    }
}

