/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.core;

import java.sql.Date;
import java.sql.SQLException;
import java.util.BitSet;
import java.util.Calendar;
import org.sqlite.SQLiteConnection;
import org.sqlite.date.FastDateFormat;
import org.sqlite.jdbc4.JDBC4Statement;

public abstract class CorePreparedStatement
extends JDBC4Statement {
    protected int columnCount;
    protected int paramCount;
    protected int batchQueryCount;
    protected BitSet paramValid;

    protected CorePreparedStatement(SQLiteConnection conn, String sql) throws SQLException {
        super(conn);
        this.sql = sql;
        this.db.prepare(this);
        this.rs.colsMeta = this.db.column_names(this.pointer);
        this.columnCount = this.db.column_count(this.pointer);
        this.paramCount = this.db.bind_parameter_count(this.pointer);
        this.paramValid = new BitSet(this.paramCount);
        this.batchQueryCount = 0;
        this.batch = null;
        this.batchPos = 0;
    }

    @Override
    protected void finalize() throws SQLException {
        this.close();
    }

    protected void checkParameters() throws SQLException {
        if (this.paramValid.cardinality() != this.paramCount) {
            throw new SQLException("Values not bound to statement");
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (this.batchQueryCount == 0) {
            return new int[0];
        }
        this.checkParameters();
        try {
            int[] nArray = this.db.executeBatch(this.pointer, this.batchQueryCount, this.batch);
            return nArray;
        }
        finally {
            this.clearBatch();
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        super.clearBatch();
        this.paramValid.clear();
        this.batchQueryCount = 0;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.pointer == 0L || this.resultsWaiting || this.rs.isOpen()) {
            return -1;
        }
        return this.db.changes();
    }

    protected void batch(int pos, Object value) throws SQLException {
        this.checkOpen();
        if (this.batch == null) {
            this.batch = new Object[this.paramCount];
            this.paramValid.clear();
        }
        this.batch[this.batchPos + pos - 1] = value;
        this.paramValid.set(pos - 1);
    }

    protected void setDateByMilliseconds(int pos, Long value, Calendar calendar) throws SQLException {
        switch (this.conn.dateClass) {
            case TEXT: {
                this.batch(pos, FastDateFormat.getInstance(this.conn.dateStringFormat, calendar.getTimeZone()).format(new Date(value)));
                break;
            }
            case REAL: {
                this.batch(pos, new Double((double)value.longValue() / 8.64E7 + 2440587.5));
                break;
            }
            default: {
                this.batch(pos, new Long(value / this.conn.dateMultiplier));
            }
        }
    }
}

