/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.mysql.MySQLConnection;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.DatabaseType;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.JdbcUtils;
import org.flywaydb.core.internal.jdbc.pro.DryRunStatementInterceptor;

public class MySQLDatabase
extends Database<MySQLConnection> {
    private static final Pattern MARIADB_VERSION_PATTERN = Pattern.compile("(\\d+\\.\\d+)\\.\\d+-MariaDB");
    private static final Log LOG = LogFactory.getLog(MySQLDatabase.class);
    private final boolean pxcStrict;
    final boolean eventSchedulerQueryable;

    public MySQLDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, DryRunStatementInterceptor dryRunStatementInterceptor) {
        super(configuration, jdbcConnectionFactory, dryRunStatementInterceptor);
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.rawMainJdbcConnection, this.databaseType);
        this.pxcStrict = MySQLDatabase.isRunningInPerconaXtraDBClusterWithStrictMode(jdbcTemplate);
        this.eventSchedulerQueryable = DatabaseType.MYSQL == this.databaseType || MySQLDatabase.isEventSchedulerQueryable(jdbcTemplate);
    }

    private static boolean isEventSchedulerQueryable(JdbcTemplate jdbcTemplate) {
        try {
            jdbcTemplate.queryForString("SELECT event_name FROM information_schema.events LIMIT 1", new String[0]);
            return true;
        }
        catch (SQLException e) {
            LOG.debug("Detected unqueryable MariaDB event scheduler, most likely due to it being OFF or DISABLED.");
            return false;
        }
    }

    static boolean isRunningInPerconaXtraDBClusterWithStrictMode(JdbcTemplate jdbcTemplate) {
        try {
            if ("ENFORCING".equals(jdbcTemplate.queryForString("select VARIABLE_VALUE from performance_schema.global_variables where variable_name = 'pxc_strict_mode'", new String[0]))) {
                LOG.debug("Detected Percona XtraDB Cluster in strict mode");
                return true;
            }
        }
        catch (SQLException e) {
            LOG.debug("Unable to detect whether we are running in a Percona XtraDB Cluster. Assuming not to be.");
        }
        return false;
    }

    boolean isMariaDB() {
        return this.databaseType == DatabaseType.MARIADB;
    }

    boolean isPxcStrict() {
        return this.pxcStrict;
    }

    @Override
    public String getRawCreateScript(Table table, boolean baseline) {
        String tablespace = !this.getVersion().isAtLeast("5.5") || this.configuration.getTablespace() == null ? "" : " TABLESPACE \"" + this.configuration.getTablespace() + "\"";
        String baselineMarker = "";
        if (baseline) {
            baselineMarker = !this.pxcStrict ? " AS SELECT     1 as \"installed_rank\",     '" + this.configuration.getBaselineVersion() + "' as \"version\",     '" + this.configuration.getBaselineDescription() + "' as \"description\",     '" + (Object)((Object)MigrationType.BASELINE) + "' as \"type\",     '" + this.configuration.getBaselineDescription() + "' as \"script\",     NULL as \"checksum\",     '" + this.getInstalledBy() + "' as \"installed_by\",     CURRENT_TIMESTAMP as \"installed_on\",     0 as \"execution_time\",     TRUE as \"success\"\n" : ";\n" + this.getBaselineStatement(table);
        }
        return "CREATE TABLE " + table + " (\n    `installed_rank` INT NOT NULL,\n    `version` VARCHAR(50),\n    `description` VARCHAR(200) NOT NULL,\n    `type` VARCHAR(20) NOT NULL,\n    `script` VARCHAR(1000) NOT NULL,\n    `checksum` INT,\n    `installed_by` VARCHAR(100) NOT NULL,\n    `installed_on` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,\n    `execution_time` INT NOT NULL,\n    `success` BOOL NOT NULL,\n    CONSTRAINT `" + table.getName() + "_pk` PRIMARY KEY (`installed_rank`)\n)" + tablespace + " ENGINE=InnoDB" + baselineMarker + ";\nCREATE INDEX `" + table.getName() + "_s_idx` ON " + table + " (`success`);";
    }

    @Override
    protected MySQLConnection doGetConnection(Connection connection) {
        return new MySQLConnection(this, connection);
    }

    @Override
    protected MigrationVersion determineVersion() {
        if (this.databaseType == DatabaseType.MARIADB) {
            try {
                String productVersion = this.jdbcMetaData.getDatabaseProductVersion();
                Matcher matcher = MARIADB_VERSION_PATTERN.matcher(productVersion);
                if (!matcher.find()) {
                    throw new FlywayException("Unable to determine MariaDB version from '" + productVersion + "'");
                }
                return MigrationVersion.fromVersion(matcher.group(1));
            }
            catch (SQLException e) {
                throw new FlywaySqlException("Unable to determine MariaDB server version", e);
            }
        }
        return super.determineVersion();
    }

    @Override
    public final void ensureSupported() {
        this.ensureDatabaseIsRecentEnough("5.1");
        if (this.databaseType == DatabaseType.MARIADB) {
            this.recommendFlywayUpgradeIfNecessary("10.4");
        } else {
            if (this.getVersion().isAtLeast("5.5") && JdbcUtils.getDriverName(this.jdbcMetaData).contains("MariaDB")) {
                LOG.warn("You are connected to a MySQL " + this.getVersion() + " database using the MariaDB driver. This is known to cause issues. An upgrade to Oracle's MySQL JDBC driver is highly recommended.");
            }
            this.recommendFlywayUpgradeIfNecessary("8.0");
        }
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return ((MySQLConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT SUBSTRING_INDEX(USER(),'@',1)", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public String doQuote(String identifier) {
        return "`" + identifier + "`";
    }

    @Override
    public boolean catalogIsSchema() {
        return true;
    }

    @Override
    public boolean useSingleConnection() {
        return !this.pxcStrict;
    }
}

