/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.zip.CRC32;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.resource.Resource;
import org.flywaydb.core.internal.util.IOUtils;
import org.flywaydb.core.internal.util.StringUtils;

public abstract class LoadableResource
implements Resource,
Comparable<LoadableResource> {
    private Integer checksum;

    public abstract Reader read();

    public boolean shouldStream() {
        return false;
    }

    public final int checksum() {
        block5: {
            if (this.checksum != null) break block5;
            CRC32 crc32 = new CRC32();
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(this.read(), 4096);
                while ((line = reader.readLine()) != null) {
                    crc32.update(StringUtils.trimLineBreak(line).getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException e) {
                try {
                    throw new FlywayException("Unable to calculate checksum for " + this.getFilename() + ": " + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    IOUtils.close(reader);
                    throw throwable;
                }
            }
            IOUtils.close(reader);
            this.checksum = (int)crc32.getValue();
        }
        return this.checksum;
    }

    @Override
    public int compareTo(LoadableResource o) {
        return this.getRelativePath().compareTo(o.getRelativePath());
    }
}

