/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.schemahistory.pro;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.pro.DryRunStatementInterceptor;
import org.flywaydb.core.internal.schemahistory.AppliedMigration;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;

public class InMemorySchemaHistory
extends SchemaHistory {
    private boolean exists;
    private final String installedBy;
    private final DryRunStatementInterceptor dryRunStatementInterceptor;
    private final List<AppliedMigration> history = new ArrayList<AppliedMigration>();

    public InMemorySchemaHistory(boolean exists, List<AppliedMigration> existingHistory, Table table, String installedBy, DryRunStatementInterceptor dryRunStatementInterceptor) {
        this.table = table;
        this.exists = exists;
        this.installedBy = installedBy;
        this.dryRunStatementInterceptor = dryRunStatementInterceptor;
        this.history.addAll(existingHistory);
    }

    @Override
    public <T> T lock(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to execute changes", e);
        }
        catch (Exception e) {
            throw new FlywayException(e);
        }
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public void create(boolean baseline) {
        if (!this.exists) {
            this.dryRunStatementInterceptor.schemaHistoryTableCreate(baseline);
            this.exists = true;
        }
    }

    @Override
    public List<AppliedMigration> allAppliedMigrations() {
        return this.history;
    }

    @Override
    public void removeFailedMigrations() {
        Iterator<AppliedMigration> iterator = this.history.iterator();
        while (iterator.hasNext()) {
            AppliedMigration appliedMigration = iterator.next();
            if (appliedMigration.isSuccess()) continue;
            iterator.remove();
        }
    }

    @Override
    public void update(AppliedMigration applied, ResolvedMigration resolved) {
        AppliedMigration updated = new AppliedMigration(applied.getInstalledRank(), applied.getVersion(), resolved.getDescription(), resolved.getType(), resolved.getScript(), resolved.getChecksum(), applied.getInstalledOn(), applied.getInstalledBy(), applied.getExecutionTime(), applied.isSuccess());
        this.dryRunStatementInterceptor.schemaHistoryTableInsert(updated);
        this.history.set(applied.getInstalledRank(), updated);
    }

    @Override
    protected void doAddAppliedMigration(int installedRank, MigrationVersion version, String description, MigrationType type, String script, Integer checksum, int executionTime, boolean success) {
        AppliedMigration appliedMigration = new AppliedMigration(installedRank, version, description, type, script, checksum, new Date(), this.installedBy, executionTime, success);
        this.dryRunStatementInterceptor.schemaHistoryTableInsert(appliedMigration);
        this.history.add(appliedMigration);
    }
}

