/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.util;

import oracle.security.crypto.fips.FIPS_140_2;

public class ArrayVector {
    protected static final int a = 32;
    protected static final int b = 2;
    protected Object[] c;
    protected int d;

    public ArrayVector() {
        this(32);
    }

    public ArrayVector(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid value for initialSize: " + n);
        }
        this.d = 0;
        this.c = new Object[n];
    }

    public ArrayVector(Object[] objectArray) {
        if (objectArray.length == 0) {
            this.c = new Object[32];
        } else {
            this.c = new Object[objectArray.length];
            System.arraycopy(objectArray, 0, this.c, 0, objectArray.length);
        }
        this.d = objectArray.length;
    }

    public void addElement(Object object) {
        if (this.d >= this.c.length) {
            Object[] objectArray = new Object[this.c.length != 0 ? this.c.length * 2 : 32];
            System.arraycopy(this.c, 0, objectArray, 0, this.c.length);
            this.c = objectArray;
        }
        this.c[this.d++] = object;
    }

    public void addElementAt(Object object, int n) {
        if (n == this.d) {
            this.addElement(object);
        } else {
            Object[] objectArray = null;
            if (this.d >= this.c.length) {
                objectArray = new Object[this.c.length != 0 ? this.c.length * 2 : 32];
                System.arraycopy(this.c, 0, objectArray, 0, n);
            } else {
                objectArray = this.c;
            }
            System.arraycopy(this.c, n, objectArray, n + 1, this.d - n);
            objectArray[n] = object;
            this.c = objectArray;
            ++this.d;
        }
    }

    public void setElementAt(Object object, int n) {
        if (n >= this.d) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        this.c[n] = object;
    }

    public Object elementAt(int n) {
        if (n >= this.d) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.c[n];
    }

    public Object[] getElements() {
        Object[] objectArray = new Object[this.d];
        System.arraycopy(this.c, 0, objectArray, 0, this.d);
        return objectArray;
    }

    public void getElements(Object[] objectArray) {
        System.arraycopy(this.c, 0, objectArray, 0, this.d);
    }

    public int size() {
        return this.d;
    }

    public void clear() {
        for (int i = 0; i < this.d; ++i) {
            this.c[i] = null;
        }
        this.d = 0;
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

