/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.bigquery;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.database.bigquery.BigQueryConnection;

public class BigQueryDatabase
extends Database<BigQueryConnection> {
    public BigQueryDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    protected BigQueryConnection doGetConnection(Connection connection) {
        return new BigQueryConnection(this, connection);
    }

    public final void ensureSupported() {
    }

    public String getRawCreateScript(Table table, boolean baseline) {
        return "CREATE TABLE " + table + " (\n    `installed_rank` INT64 NOT NULL,\n    `version` STRING,\n    `description` STRING NOT NULL,\n    `type` STRING NOT NULL,\n    `script` STRING NOT NULL,\n    `checksum` INT64,\n    `installed_by` STRING NOT NULL,\n    `installed_on` TIMESTAMP,\n    `execution_time` INT64 NOT NULL,\n    `success` BOOL NOT NULL\n);\n" + (baseline ? this.getBaselineStatement(table) + ";\n" : "");
    }

    public String getInsertStatement(Table table) {
        return "INSERT INTO " + table + " (" + this.quote(new String[]{"installed_rank"}) + ", " + this.quote(new String[]{"version"}) + ", " + this.quote(new String[]{"description"}) + ", " + this.quote(new String[]{"type"}) + ", " + this.quote(new String[]{"script"}) + ", " + this.quote(new String[]{"checksum"}) + ", " + this.quote(new String[]{"installed_by"}) + ", " + this.quote(new String[]{"installed_on"}) + ", " + this.quote(new String[]{"execution_time"}) + ", " + this.quote(new String[]{"success"}) + ") VALUES (?, ?, ?, ?, ?, ?, ?, CURRENT_TIMESTAMP(), ?, ?)";
    }

    protected String doGetCurrentUser() throws SQLException {
        return ((BigQueryConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT SESSION_USER() as user;", new String[0]);
    }

    public boolean supportsDdlTransactions() {
        return false;
    }

    public boolean supportsChangingCurrentSchema() {
        return false;
    }

    public String getBooleanTrue() {
        return "TRUE";
    }

    public String getBooleanFalse() {
        return "FALSE";
    }

    public String doQuote(String identifier) {
        return BigQueryDatabase.bigQueryQuote(identifier);
    }

    static String bigQueryQuote(String identifier) {
        return "`" + StringUtils.replaceAll((String)identifier, (String)"`", (String)"\\`") + "`";
    }

    public boolean catalogIsSchema() {
        return false;
    }

    public boolean supportsMultiStatementTransactions() {
        return false;
    }

    public boolean useSingleConnection() {
        return true;
    }
}

