/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AsyncRunner;
import com.google.cloud.spanner.AsyncTransactionManager;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.Session;
import com.google.cloud.spanner.SessionNotFoundException;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TraceUtil;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.util.concurrent.ListenableFuture;
import io.opencensus.common.Scope;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;

class DatabaseClientImpl
implements DatabaseClient {
    private static final String READ_WRITE_TRANSACTION = "CloudSpanner.ReadWriteTransaction";
    private static final String READ_ONLY_TRANSACTION = "CloudSpanner.ReadOnlyTransaction";
    private static final String PARTITION_DML_TRANSACTION = "CloudSpanner.PartitionDMLTransaction";
    private static final Tracer tracer = Tracing.getTracer();
    @VisibleForTesting
    final String clientId;
    @VisibleForTesting
    final SessionPool pool;

    @VisibleForTesting
    DatabaseClientImpl(SessionPool pool) {
        this("", pool);
    }

    DatabaseClientImpl(String clientId, SessionPool pool) {
        this.clientId = clientId;
        this.pool = pool;
    }

    @VisibleForTesting
    SessionPool.PooledSessionFuture getSession() {
        return this.pool.getSession();
    }

    @Override
    public Timestamp write(Iterable<Mutation> mutations) throws SpannerException {
        return this.writeWithOptions(mutations, new Options.TransactionOption[0]).getCommitTimestamp();
    }

    /*
     * Exception decompiling
     */
    @Override
    public CommitResponse writeWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... options) throws SpannerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Timestamp writeAtLeastOnce(Iterable<Mutation> mutations) throws SpannerException {
        return this.writeAtLeastOnceWithOptions(mutations, new Options.TransactionOption[0]).getCommitTimestamp();
    }

    /*
     * Exception decompiling
     */
    @Override
    public CommitResponse writeAtLeastOnceWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... options) throws SpannerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ReadContext singleUse() {
        Span span = tracer.spanBuilder(READ_ONLY_TRANSACTION).startSpan();
        try (Scope s = tracer.withSpan(span);){
            ReadContext readContext = this.getSession().singleUse();
            return readContext;
        }
        catch (RuntimeException e) {
            TraceUtil.endSpanWithFailure(span, e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ReadContext singleUse(TimestampBound bound) {
        Span span = tracer.spanBuilder(READ_ONLY_TRANSACTION).startSpan();
        try (Scope s = tracer.withSpan(span);){
            ReadContext readContext = this.getSession().singleUse(bound);
            return readContext;
        }
        catch (RuntimeException e) {
            TraceUtil.endSpanWithFailure(span, e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ReadOnlyTransaction singleUseReadOnlyTransaction() {
        Span span = tracer.spanBuilder(READ_ONLY_TRANSACTION).startSpan();
        try (Scope s = tracer.withSpan(span);){
            ReadOnlyTransaction readOnlyTransaction = this.getSession().singleUseReadOnlyTransaction();
            return readOnlyTransaction;
        }
        catch (RuntimeException e) {
            TraceUtil.endSpanWithFailure(span, e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ReadOnlyTransaction singleUseReadOnlyTransaction(TimestampBound bound) {
        Span span = tracer.spanBuilder(READ_ONLY_TRANSACTION).startSpan();
        try (Scope s = tracer.withSpan(span);){
            ReadOnlyTransaction readOnlyTransaction = this.getSession().singleUseReadOnlyTransaction(bound);
            return readOnlyTransaction;
        }
        catch (RuntimeException e) {
            TraceUtil.endSpanWithFailure(span, e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ReadOnlyTransaction readOnlyTransaction() {
        Span span = tracer.spanBuilder(READ_ONLY_TRANSACTION).startSpan();
        try (Scope s = tracer.withSpan(span);){
            ReadOnlyTransaction readOnlyTransaction = this.getSession().readOnlyTransaction();
            return readOnlyTransaction;
        }
        catch (RuntimeException e) {
            TraceUtil.endSpanWithFailure(span, e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ReadOnlyTransaction readOnlyTransaction(TimestampBound bound) {
        Span span = tracer.spanBuilder(READ_ONLY_TRANSACTION).startSpan();
        try (Scope s = tracer.withSpan(span);){
            ReadOnlyTransaction readOnlyTransaction = this.getSession().readOnlyTransaction(bound);
            return readOnlyTransaction;
        }
        catch (RuntimeException e) {
            TraceUtil.endSpanWithFailure(span, e);
            throw e;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public TransactionRunner readWriteTransaction(Options.TransactionOption ... options) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TransactionManager transactionManager(Options.TransactionOption ... options) {
        Span span = tracer.spanBuilder(READ_WRITE_TRANSACTION).startSpan();
        try (Scope s = tracer.withSpan(span);){
            TransactionManager transactionManager = this.getSession().transactionManager(options);
            return transactionManager;
        }
        catch (RuntimeException e) {
            TraceUtil.endSpanWithFailure(span, e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AsyncRunner runAsync(Options.TransactionOption ... options) {
        Span span = tracer.spanBuilder(READ_WRITE_TRANSACTION).startSpan();
        try (Scope s = tracer.withSpan(span);){
            AsyncRunner asyncRunner = this.getSession().runAsync(options);
            return asyncRunner;
        }
        catch (RuntimeException e) {
            TraceUtil.endSpanWithFailure(span, e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AsyncTransactionManager transactionManagerAsync(Options.TransactionOption ... options) {
        Span span = tracer.spanBuilder(READ_WRITE_TRANSACTION).startSpan();
        try (Scope s = tracer.withSpan(span);){
            AsyncTransactionManager asyncTransactionManager = this.getSession().transactionManagerAsync(options);
            return asyncTransactionManager;
        }
        catch (RuntimeException e) {
            TraceUtil.endSpanWithFailure(span, e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long executePartitionedUpdate(Statement stmt, Options.UpdateOption ... options) {
        Span span = tracer.spanBuilder(PARTITION_DML_TRANSACTION).startSpan();
        try (Scope s = tracer.withSpan(span);){
            long l = (Long)this.runWithSessionRetry(session -> session.executePartitionedUpdate(stmt, options));
            return l;
        }
        catch (RuntimeException e) {
            TraceUtil.endSpanWithFailure(span, e);
            throw e;
        }
    }

    private <T> T runWithSessionRetry(Function<Session, T> callable) {
        SessionPool.PooledSessionFuture session = this.getSession();
        while (true) {
            try {
                return (T)callable.apply((Object)session);
            }
            catch (SessionNotFoundException e) {
                session = this.pool.replaceSession(e, session);
                continue;
            }
            break;
        }
    }

    ListenableFuture<Void> closeAsync(SpannerImpl.ClosedException closedException) {
        return this.pool.closeAsync(closedException);
    }

    private static /* synthetic */ CommitResponse lambda$writeAtLeastOnceWithOptions$1(Iterable mutations, Options.TransactionOption[] options, Session session) {
        return session.writeAtLeastOnceWithOptions(mutations, options);
    }

    private static /* synthetic */ CommitResponse lambda$writeWithOptions$0(Iterable mutations, Options.TransactionOption[] options, Session session) {
        return session.writeWithOptions(mutations, options);
    }
}

