/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.jdbc;

import com.google.cloud.spanner.jdbc.JdbcPreconditions;
import com.google.cloud.spanner.jdbc.JdbcSqlExceptionFactory;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;

class JdbcClob
implements NClob {
    private StringBuilder value = new StringBuilder();

    JdbcClob() {
    }

    JdbcClob(String value) {
        this.value.append(value);
    }

    private void checkPosition(long pos) {
        Preconditions.checkArgument((pos + 1L <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"position larger than 2147483647 is not supported");
    }

    private void checkLength(long length) {
        Preconditions.checkArgument((length <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"length larger than 2147483647 is not supported");
    }

    private void checkPositionPlusLength(long pos, long length) {
        Preconditions.checkArgument((pos + 1L + length <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"position+length larger than 2147483647 is not supported");
    }

    private StringBuilder repeat(char c, long length) {
        this.checkLength(length);
        StringBuilder res = new StringBuilder((int)length);
        int i = 0;
        while ((long)i < length) {
            res.append(c);
            ++i;
        }
        return res;
    }

    @Override
    public long length() throws SQLException {
        return this.value.length();
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        JdbcPreconditions.checkArgument(pos >= 1L, "Start position must be >= 1");
        JdbcPreconditions.checkArgument(length >= 0, "Length must be >= 0");
        this.checkPosition(pos);
        this.checkPositionPlusLength(pos, length);
        if (pos > this.length()) {
            return "";
        }
        int end = (int)pos + length - 1;
        if (end >= this.value.length()) {
            end = this.value.length();
        }
        return this.value.substring((int)pos - 1, end);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return new StringReader(this.value.toString());
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return new ByteArrayInputStream(StandardCharsets.US_ASCII.encode(this.value.toString()).array());
    }

    @Override
    public long position(String searchStr, long start) throws SQLException {
        JdbcPreconditions.checkArgument(start >= 1L, "Start position must be >= 1");
        JdbcPreconditions.checkArgument(searchStr != null, "searchStr may not be null");
        this.checkPosition(start);
        int res = this.value.indexOf(searchStr, (int)start - 1);
        if (res == -1) {
            return res;
        }
        return res + 1;
    }

    @Override
    public long position(Clob searchStr, long start) throws SQLException {
        JdbcPreconditions.checkArgument(start >= 1L, "Start position must be >= 1");
        JdbcPreconditions.checkArgument(searchStr != null, "searchStr may not be null");
        this.checkPosition(start);
        this.checkPositionPlusLength(start, searchStr.length());
        int res = this.value.indexOf(searchStr.getSubString(1L, (int)searchStr.length()), (int)start - 1);
        if (res == -1) {
            return res;
        }
        return res + 1;
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        JdbcPreconditions.checkArgument(str != null, "str is null");
        JdbcPreconditions.checkArgument(pos >= 1L, "Position must be >= 1");
        this.checkPosition(pos);
        if (pos - 1L > this.length()) {
            this.value.append((CharSequence)this.repeat(' ', pos - this.length() - 1L));
        }
        this.value.replace((int)pos - 1, (int)pos + str.length() - 1, str);
        return str.length();
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        JdbcPreconditions.checkArgument(str != null, "str is null");
        JdbcPreconditions.checkArgument(pos >= 1L, "Position must be >= 1");
        JdbcPreconditions.checkArgument(offset >= 1, "Offset must be >= 1");
        JdbcPreconditions.checkArgument(offset + len - 1 <= str.length(), "offset + len is greater than str.length()");
        this.checkPosition(pos);
        return this.setString(pos, str.substring(offset - 1, offset + len - 1));
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw JdbcSqlExceptionFactory.unsupported("setAsciiStream is not supported. Use setCharacterStream instead");
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        JdbcPreconditions.checkArgument(pos >= 1L, "pos must be >= 1");
        return new ClobWriter(pos);
    }

    @Override
    public void truncate(long len) throws SQLException {
        JdbcPreconditions.checkArgument(len >= 0L, "len must be >= 0");
        this.checkLength(len);
        this.value.setLength((int)len);
    }

    @Override
    public void free() throws SQLException {
        this.value = new StringBuilder();
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        JdbcPreconditions.checkArgument(pos >= 1L, "pos must be >= 1");
        JdbcPreconditions.checkArgument(length >= 0L, "length must be >= 0");
        this.checkPosition(pos);
        this.checkPositionPlusLength(pos, length);
        return new StringReader(this.value.substring((int)pos - 1, (int)pos + (int)length - 1).toString());
    }

    public boolean equals(Object other) {
        if (!(other instanceof JdbcClob)) {
            return false;
        }
        JdbcClob blob = (JdbcClob)other;
        return this.value.toString().equals(blob.value.toString());
    }

    public int hashCode() {
        return this.value.toString().hashCode();
    }

    private class ClobWriter
    extends StringWriter {
        private final long startPos;

        private ClobWriter(long startPos) {
            this.startPos = startPos;
        }

        @Override
        public void flush() {
            try {
                JdbcClob.this.setString(this.startPos, this.getBuffer().toString());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() {
            this.flush();
        }
    }
}

