/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.oracle.teams;

import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.database.oracle.teams.AbstractSQLPlusParsedSqlStatement;
import org.flywaydb.core.internal.database.oracle.teams.SQLPlusParserSqlScript;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.resource.filesystem.FileSystemResource;
import org.flywaydb.core.internal.sqlscript.SqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutor;
import org.flywaydb.core.internal.sqlscript.SqlScriptMetadata;

public class SQLPlusLoginStatement
extends AbstractSQLPlusParsedSqlStatement {
    private static final Log LOG = LogFactory.getLog(SQLPlusLoginStatement.class);
    private final SqlScript referencedSqlScript;

    public SQLPlusLoginStatement(Parser parser, ResourceProvider resourceProvider, boolean global) {
        super(0, 0, 0, "");
        LoadableResource resource = null;
        if (global) {
            File glogin;
            String oracleHome = System.getenv("ORACLE_HOME");
            if (oracleHome != null && (glogin = new File(oracleHome, "sqlplus/admin/glogin.sql")).exists()) {
                LOG.debug("Found global SQL*Plus resource: " + glogin.getAbsolutePath() + ". This is treated as a referenced script and will affect your checksums! Visit " + "https://rd.gt/3AdsFHj" + " for more information");
                resource = new FileSystemResource(null, glogin.getAbsolutePath(), Charset.defaultCharset(), false);
            }
        } else if (resourceProvider != null) {
            resource = resourceProvider.getResource("login.sql");
        }
        if (resource != null) {
            LoadableResource metadataResource = SqlScriptMetadata.getMetadataResource(resourceProvider, resource);
            this.referencedSqlScript = new SQLPlusParserSqlScript(parser, resource, metadataResource, false, new ArrayList<String>());
        } else {
            this.referencedSqlScript = null;
        }
    }

    @Override
    public SqlScript getReferencedSqlScript() {
        return this.referencedSqlScript;
    }

    @Override
    public Results execute(JdbcTemplate jdbcTemplate, SqlScriptExecutor sqlScriptExecutor) {
        if (this.referencedSqlScript != null) {
            sqlScriptExecutor.execute(this.referencedSqlScript);
        }
        return new Results();
    }
}

