/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resolver.teams.script;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resolver.Context;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.callback.teams.ArbitraryScriptCallback;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.parser.PlaceholderReplacingReader;
import org.flywaydb.core.internal.resolver.ChecksumCalculator;
import org.flywaydb.core.internal.resolver.ResolvedMigrationComparator;
import org.flywaydb.core.internal.resolver.ResolvedMigrationImpl;
import org.flywaydb.core.internal.resolver.teams.script.ScriptMigrationExecutor;
import org.flywaydb.core.internal.resource.ResourceName;
import org.flywaydb.core.internal.resource.ResourceNameParser;
import org.flywaydb.core.internal.util.StringUtils;

public class ScriptMigrationResolver
implements MigrationResolver {
    private static final Log LOG = LogFactory.getLog(ScriptMigrationResolver.class);
    private final ResourceProvider resourceProvider;
    private final Configuration configuration;
    private final ParsingContext parsingContext;
    public final Set<Callback> scriptCallbacks;
    private final String[] fileTypes = new String[]{"cmd", "bat", "ps1", "py", "sh", "bash"};

    public ScriptMigrationResolver(ResourceProvider resourceProvider, Configuration configuration, ParsingContext parsingContext) {
        this.resourceProvider = resourceProvider;
        this.configuration = configuration;
        this.parsingContext = parsingContext;
        this.scriptCallbacks = new HashSet<Callback>();
    }

    @Override
    public Collection<ResolvedMigration> resolveMigrations(Context context) {
        ArrayList<ResolvedMigration> migrations = new ArrayList<ResolvedMigration>();
        this.addMigrations(migrations, this.configuration.getSqlMigrationPrefix(), this.fileTypes, false, false);
        this.addMigrations(migrations, this.configuration.getUndoSqlMigrationPrefix(), this.fileTypes, false, true);
        this.addMigrations(migrations, this.configuration.getRepeatableSqlMigrationPrefix(), this.fileTypes, true, false);
        migrations.sort(new ResolvedMigrationComparator());
        return migrations;
    }

    private LoadableResource[] createPlaceholderReplacingLoadableResources(List<LoadableResource> loadableResources) {
        ArrayList<1> list = new ArrayList<1>();
        for (final LoadableResource loadableResource : loadableResources) {
            LoadableResource placeholderReplacingLoadableResource = new LoadableResource(){

                @Override
                public Reader read() {
                    return PlaceholderReplacingReader.createForScriptMigration(ScriptMigrationResolver.this.configuration, ScriptMigrationResolver.this.parsingContext, loadableResource.read());
                }

                @Override
                public String getAbsolutePath() {
                    return loadableResource.getAbsolutePath();
                }

                @Override
                public String getAbsolutePathOnDisk() {
                    return loadableResource.getAbsolutePathOnDisk();
                }

                @Override
                public String getFilename() {
                    return loadableResource.getFilename();
                }

                @Override
                public String getRelativePath() {
                    return loadableResource.getRelativePath();
                }
            };
            list.add(placeholderReplacingLoadableResource);
        }
        return list.toArray(new LoadableResource[0]);
    }

    private Integer getChecksumForLoadableResource(boolean repeatable, List<LoadableResource> loadableResources) {
        if (repeatable && this.configuration.isPlaceholderReplacement()) {
            return ChecksumCalculator.calculate(this.createPlaceholderReplacingLoadableResources(loadableResources));
        }
        return ChecksumCalculator.calculate(loadableResources.toArray(new LoadableResource[0]));
    }

    private Integer getEquivalentChecksumForLoadableResource(boolean repeatable, List<LoadableResource> loadableResources) {
        if (repeatable) {
            return ChecksumCalculator.calculate(loadableResources.toArray(new LoadableResource[0]));
        }
        return null;
    }

    public void resolveCallbacks() {
        String[] suffixes = (String[])Arrays.stream(this.fileTypes).map(s -> "." + s).toArray(String[]::new);
        this.addCallbacks(suffixes);
    }

    private void addMigrations(List<ResolvedMigration> migrations, String prefix, String[] suffixes, boolean repeatable, boolean undo) {
        ResourceNameParser resourceNameParser = new ResourceNameParser(this.configuration);
        for (LoadableResource resource : this.resourceProvider.getResources(prefix, new String[]{""})) {
            String filename = resource.getFilename();
            ResourceName result = resourceNameParser.parse(filename);
            if (!result.isValid() || ScriptMigrationResolver.isCallback(result) || !prefix.equals(result.getPrefix()) || this.isNotScriptFile(suffixes, filename)) continue;
            ArrayList<LoadableResource> resources = new ArrayList<LoadableResource>();
            resources.add(resource);
            Integer checksum = this.getChecksumForLoadableResource(repeatable, resources);
            Integer equivalentChecksum = this.getEquivalentChecksumForLoadableResource(repeatable, resources);
            migrations.add(new ResolvedMigrationImpl(result.getVersion(), result.getDescription(), resource.getRelativePath(), checksum, equivalentChecksum, undo ? MigrationType.UNDO_SCRIPT : MigrationType.SCRIPT, resource.getAbsolutePathOnDisk(), new ScriptMigrationExecutor(resource)){

                @Override
                public void validate() {
                }
            });
        }
    }

    private void addCallbacks(String[] suffixes) {
        ResourceNameParser resourceNameParser = new ResourceNameParser(this.configuration);
        for (LoadableResource resource : this.resourceProvider.getResources("", new String[]{""})) {
            String filename = resource.getFilename();
            ResourceName result = resourceNameParser.parse(filename, suffixes);
            if (!result.isValid() || this.isNotScriptFile(this.fileTypes, filename) || !ScriptMigrationResolver.isCallback(result)) continue;
            LOG.debug("Found script callback: " + resource.getAbsolutePath() + " (filename: " + resource.getFilename() + ")");
            this.scriptCallbacks.add(new ArbitraryScriptCallback(Event.fromId(result.getPrefix()), result.getDescription(), new ScriptMigrationExecutor(resource)));
        }
    }

    private boolean isNotScriptFile(String[] suffixes, String filename) {
        boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win");
        String extension = StringUtils.getFileExtension(filename);
        boolean isScriptFile = false;
        if (!isWindows) {
            isScriptFile = extension.isEmpty();
        }
        if (!isScriptFile) {
            for (String suffix : suffixes) {
                if (!suffix.equals(extension)) continue;
                isScriptFile = true;
                break;
            }
        }
        return !isScriptFile;
    }

    private static boolean isCallback(ResourceName result) {
        return Event.fromId(result.getPrefix()) != null;
    }
}

