/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flywaydb.commandline.CommandLineArguments;
import org.flywaydb.commandline.MavenVersionChecker;
import org.flywaydb.commandline.RedgateUpdateChecker;
import org.flywaydb.commandline.logging.console.ConsoleLog;
import org.flywaydb.commandline.logging.console.ConsoleLogCreator;
import org.flywaydb.commandline.logging.file.FileLogCreator;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogCreator;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.CleanResult;
import org.flywaydb.core.api.output.CompositeResult;
import org.flywaydb.core.api.output.ErrorOutput;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.api.output.OperationResultBase;
import org.flywaydb.core.api.teams.MigrationFilter;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.database.DatabaseType;
import org.flywaydb.core.internal.database.DatabaseTypeRegister;
import org.flywaydb.core.internal.info.MigrationInfoDumper;
import org.flywaydb.core.internal.info.teams.MigrationFilterImpl;
import org.flywaydb.core.internal.license.FlywayTrialExpiredException;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.license.teams.FlywayExpiredLicenseKeyException;
import org.flywaydb.core.internal.license.teams.FlywayInvalidLicenseKeyException;
import org.flywaydb.core.internal.license.teams.FlywayMissingLicenseKeyException;
import org.flywaydb.core.internal.license.teams.FlywayRedgateLicenseKeyException;
import org.flywaydb.core.internal.license.teams.LicenseInfo;
import org.flywaydb.core.internal.logging.EvolvingLog;
import org.flywaydb.core.internal.logging.buffered.BufferedLog;
import org.flywaydb.core.internal.logging.multi.MultiLogCreator;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.schemahistory.SchemaHistoryFactory;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.FeatureDetector;
import org.flywaydb.core.internal.util.StringUtils;

public class Main {
    private static Log LOG;
    private static final int TEAMS_LICENCED_RETURN_CODE = 0;
    private static final int TEAMS_UNLICENSED_RETURN_CODE = 100;
    private static final int TEAMS_EXPIRED_LICENCE_RETURN_CODE = 101;
    private static final int TEAMS_EXPIRED_TRIAL_LICENCE_RETURN_CODE = 102;
    private static final int TEAMS_UNREADABLE_LICENCE_RETURN_CODE = 103;

    static LogCreator getLogCreator(CommandLineArguments commandLineArguments) {
        if (commandLineArguments.shouldOutputJson()) {
            return MultiLogCreator.empty();
        }
        ArrayList<Object> logCreators = new ArrayList<Object>();
        logCreators.add(new ConsoleLogCreator(commandLineArguments));
        if (commandLineArguments.isOutputFileSet()) {
            logCreators.add(new FileLogCreator(commandLineArguments));
        }
        return new MultiLogCreator(logCreators);
    }

    static void initLogging(CommandLineArguments commandLineArguments) {
        LogFactory.setFallbackLogCreator((LogCreator)Main.getLogCreator(commandLineArguments));
        LOG = LogFactory.getLog(Main.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        CommandLineArguments commandLineArguments = new CommandLineArguments(args);
        Main.initLogging(commandLineArguments);
        try {
            CompositeResult result;
            commandLineArguments.validate();
            if (!commandLineArguments.shouldCheckLicenseAndExit() && commandLineArguments.shouldPrintVersionAndExit()) {
                Main.printVersion();
                System.exit(0);
            }
            if (commandLineArguments.hasOperation("help") || commandLineArguments.shouldPrintUsage()) {
                Main.printUsage();
                return;
            }
            Map envVars = ConfigUtils.environmentVariablesToPropertyMap();
            Map<String, String> config = new HashMap<String, String>();
            Main.initializeDefaults(config, commandLineArguments);
            Main.loadConfigurationFromConfigFiles(config, commandLineArguments, envVars);
            if (commandLineArguments.isWorkingDirectorySet()) {
                Main.makeRelativeLocationsBasedOnWorkingDirectory(commandLineArguments, config);
            }
            config.putAll(envVars);
            config = Main.overrideConfiguration(config, commandLineArguments.getConfiguration());
            config = Main.overrideConfiguration(config, ConfigUtils.loadConfigurationFromSecretsManagers(config));
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            ArrayList<File> jarFiles = new ArrayList<File>();
            jarFiles.addAll(Main.getJdbcDriverJarFiles());
            jarFiles.addAll(Main.getJavaMigrationJarFiles(config));
            if (!jarFiles.isEmpty()) {
                classLoader = ClassUtils.addJarsOrDirectoriesToClasspath((ClassLoader)classLoader, jarFiles);
            }
            if (!commandLineArguments.shouldSuppressPrompt()) {
                Main.promptForCredentialsIfMissing(config);
            }
            ConfigUtils.dumpConfiguration(config);
            Main.filterProperties(config);
            if (!commandLineArguments.skipCheckForUpdate()) {
                if (FeatureDetector.isRedgateUpdateCheckEnabled()) {
                    String message = RedgateUpdateChecker.getUpdateCheckMessage(config.get("flyway.url"));
                    if (!message.isEmpty()) {
                        LOG.info(message);
                    }
                } else {
                    MavenVersionChecker.checkForVersionUpdates();
                }
            }
            Flyway flyway = Flyway.configure((ClassLoader)classLoader).configuration(config).load();
            if (commandLineArguments.shouldCheckLicenseAndExit()) {
                System.exit(Main.checkLicense(flyway.getConfiguration()));
            }
            if (commandLineArguments.getOperations().size() == 1) {
                String operation = commandLineArguments.getOperations().get(0);
                result = Main.executeOperation(flyway, operation, commandLineArguments);
            } else {
                result = new CompositeResult();
                for (String operation : commandLineArguments.getOperations()) {
                    OperationResultBase individualResult = Main.executeOperation(flyway, operation, commandLineArguments);
                    result.individualResults.add(individualResult);
                }
            }
            if (commandLineArguments.shouldOutputJson()) {
                if (commandLineArguments.shouldWarnAboutDeprecatedFlag()) {
                    String message = "Option -json is deprecated; use -outputType=json instead";
                    LOG.warn(message);
                    result.addWarning(message);
                }
                Main.printJson(commandLineArguments, (OperationResult)result);
            }
        }
        catch (Exception e) {
            if (commandLineArguments.shouldOutputJson()) {
                ErrorOutput errorOutput = ErrorOutput.fromException((Exception)e);
                Main.printJson(commandLineArguments, (OperationResult)errorOutput);
            } else if (commandLineArguments.getLogLevel() == ConsoleLog.Level.DEBUG) {
                LOG.error("Unexpected error", e);
            } else {
                LOG.error(Main.getMessagesFromException(e));
            }
            Log currentLog = ((EvolvingLog)LOG).getLog();
            if (currentLog instanceof BufferedLog) {
                ((BufferedLog)currentLog).flush(Main.getLogCreator(commandLineArguments).createLogger(Main.class));
            }
            System.exit(1);
        }
        finally {
            Log currentLog = ((EvolvingLog)LOG).getLog();
            if (currentLog instanceof BufferedLog) {
                ((BufferedLog)currentLog).flush(Main.getLogCreator(commandLineArguments).createLogger(Main.class));
            }
        }
    }

    private static void makeRelativeLocationsBasedOnWorkingDirectory(CommandLineArguments commandLineArguments, Map<String, String> config) {
        Object[] locations = config.get("flyway.locations").split(",");
        for (int i = 0; i < locations.length; ++i) {
            if (!locations[i].startsWith("filesystem:")) continue;
            String newLocation = ((String)locations[i]).substring("filesystem:".length());
            File file = new File(newLocation);
            if (!file.isAbsolute()) {
                file = new File(commandLineArguments.getWorkingDirectory(), newLocation);
            }
            locations[i] = "filesystem:" + file.getAbsolutePath();
        }
        config.put("flyway.locations", StringUtils.arrayToCommaDelimitedString((Object[])locations));
    }

    private static Map<String, String> overrideConfiguration(Map<String, String> existingConfiguration, Map<String, String> newConfiguration) {
        HashMap<String, String> combinedConfiguration = new HashMap<String, String>();
        combinedConfiguration.putAll(existingConfiguration);
        combinedConfiguration.putAll(newConfiguration);
        return combinedConfiguration;
    }

    static String getMessagesFromException(Throwable e) {
        StringBuilder condensedMessages = new StringBuilder();
        String preamble = "";
        while (e != null) {
            if (e instanceof FlywayException) {
                condensedMessages.append(preamble).append(e.getMessage());
            } else {
                condensedMessages.append(preamble).append(e);
            }
            preamble = "\r\nCaused by: ";
            e = e.getCause();
        }
        return condensedMessages.toString();
    }

    private static OperationResultBase executeOperation(Flyway flyway, String operation, CommandLineArguments commandLineArguments) {
        CleanResult result = null;
        if ("clean".equals(operation)) {
            result = flyway.clean();
        } else if ("baseline".equals(operation)) {
            result = flyway.baseline();
        } else if ("migrate".equals(operation)) {
            result = flyway.migrate();
        } else if ("undo".equals(operation)) {
            result = flyway.undo();
        } else if ("validate".equals(operation)) {
            if (commandLineArguments.shouldOutputJson()) {
                result = flyway.validateWithResult();
            } else {
                flyway.validate();
            }
        } else if ("info".equals(operation)) {
            MigrationInfoService info = flyway.info();
            MigrationInfo current = info.current();
            MigrationVersion currentSchemaVersion = current == null ? MigrationVersion.EMPTY : current.getVersion();
            MigrationVersion schemaVersionToOutput = currentSchemaVersion == null ? MigrationVersion.EMPTY : currentSchemaVersion;
            LOG.info("Schema version: " + schemaVersionToOutput);
            LOG.info("");
            MigrationFilterImpl filter = Main.getInfoFilter(commandLineArguments);
            result = info.getInfoResult((MigrationFilter)filter);
            MigrationInfo[] infos = info.all((MigrationFilter)filter);
            LOG.info(MigrationInfoDumper.dumpToAsciiTable((MigrationInfo[])infos));
        } else if ("repair".equals(operation)) {
            result = flyway.repair();
        } else {
            LOG.error("Invalid operation: " + operation);
            Main.printUsage();
            System.exit(1);
        }
        return result;
    }

    private static MigrationFilterImpl getInfoFilter(CommandLineArguments commandLineArguments) {
        return new MigrationFilterImpl(commandLineArguments.getInfoSinceDate(), commandLineArguments.getInfoUntilDate(), commandLineArguments.getInfoSinceVersion(), commandLineArguments.getInfoUntilVersion(), commandLineArguments.getInfoOfState());
    }

    private static void printJson(CommandLineArguments commandLineArguments, OperationResult object) {
        String json = Main.convertObjectToJsonString(object);
        if (commandLineArguments.isOutputFileSet()) {
            Path path = Paths.get(commandLineArguments.getOutputFile(), new String[0]);
            byte[] bytes = json.getBytes();
            try {
                Files.write(path, bytes, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
            }
            catch (IOException e) {
                throw new FlywayException("Could not write to output file " + commandLineArguments.getOutputFile(), (Throwable)e);
            }
        }
        System.out.println(json);
    }

    private static String convertObjectToJsonString(Object object) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().serializeNulls().create();
        return gson.toJson(object);
    }

    private static void initializeDefaults(Map<String, String> config, CommandLineArguments commandLineArguments) {
        String workingDirectory = commandLineArguments.isWorkingDirectorySet() ? commandLineArguments.getWorkingDirectory() : Main.getInstallationDir();
        config.put("flyway.locations", "filesystem:" + new File(workingDirectory, "sql").getAbsolutePath());
        config.put("flyway.jarDirs", new File(workingDirectory, "jars").getAbsolutePath());
    }

    private static void filterProperties(Map<String, String> config) {
        config.remove("flyway.jarDirs");
        config.remove("flyway.configFiles");
        config.remove("flyway.configFileEncoding");
    }

    private static int checkLicense(Configuration configuration) {
        try {
            FluentConfiguration checkLicenseConfiguration = new FluentConfiguration().configuration(configuration).connectRetries(0);
            LicenseInfo.create((String)checkLicenseConfiguration.getLicenseKey(), (SchemaHistory)SchemaHistoryFactory.getSchemaHistory((Configuration)checkLicenseConfiguration));
            return 0;
        }
        catch (FlywayMissingLicenseKeyException e) {
            return 100;
        }
        catch (FlywayInvalidLicenseKeyException | FlywayRedgateLicenseKeyException e) {
            return 103;
        }
        catch (FlywayExpiredLicenseKeyException e) {
            return 101;
        }
        catch (FlywayTrialExpiredException e) {
            return 102;
        }
    }

    private static void printVersion() {
        VersionPrinter.printVersionOnly();
        LOG.info("");
        LOG.debug("Java " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")");
        LOG.debug(System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + "\n");
    }

    private static void printUsage() {
        LOG.info("Usage");
        LOG.info("=====");
        LOG.info("");
        LOG.info("flyway [options] command");
        LOG.info("");
        LOG.info("By default, the configuration will be read from conf/flyway.conf.");
        LOG.info("Options passed from the command-line override the configuration.");
        LOG.info("");
        LOG.info("Commands");
        LOG.info("--------");
        LOG.info("migrate  : Migrates the database");
        LOG.info("clean    : Drops all objects in the configured schemas");
        LOG.info("info     : Prints the information about applied, current and pending migrations");
        LOG.info("validate : Validates the applied migrations against the ones on the classpath");
        LOG.info("undo     : [teams] Undoes the most recently applied versioned migration");
        LOG.info("baseline : Baselines an existing database at the baselineVersion");
        LOG.info("repair   : Repairs the schema history table");
        LOG.info("");
        LOG.info("Options (Format: -key=value)");
        LOG.info("-------");
        LOG.info("driver                       : Fully qualified classname of the JDBC driver");
        LOG.info("url                          : Jdbc url to use to connect to the database");
        LOG.info("user                         : User to use to connect to the database");
        LOG.info("password                     : Password to use to connect to the database");
        LOG.info("connectRetries               : Maximum number of retries when attempting to connect to the database");
        LOG.info("initSql                      : SQL statements to run to initialize a new database connection");
        LOG.info("schemas                      : Comma-separated list of the schemas managed by Flyway");
        LOG.info("table                        : Name of Flyway's schema history table");
        LOG.info("locations                    : Classpath locations to scan recursively for migrations");
        LOG.info("failOnMissingLocations       : Whether to fail if a location specified in the flyway.locations option doesn't exist");
        LOG.info("resolvers                    : Comma-separated list of custom MigrationResolvers");
        LOG.info("skipDefaultResolvers         : Skips default resolvers (jdbc, sql and Spring-jdbc)");
        LOG.info("sqlMigrationPrefix           : File name prefix for versioned SQL migrations");
        LOG.info("undoSqlMigrationPrefix       : [teams] File name prefix for undo SQL migrations");
        LOG.info("repeatableSqlMigrationPrefix : File name prefix for repeatable SQL migrations");
        LOG.info("sqlMigrationSeparator        : File name separator for SQL migrations");
        LOG.info("sqlMigrationSuffixes         : Comma-separated list of file name suffixes for SQL migrations");
        LOG.info("stream                       : [teams] Stream SQL migrations when executing them");
        LOG.info("batch                        : [teams] Batch SQL statements when executing them");
        LOG.info("mixed                        : Allow mixing transactional and non-transactional statements");
        LOG.info("encoding                     : Encoding of SQL migrations");
        LOG.info("detectEncoding               : [teams] Whether Flyway should try to automatically detect SQL migration file encoding");
        LOG.info("placeholderReplacement       : Whether placeholders should be replaced");
        LOG.info("placeholders                 : Placeholders to replace in sql migrations");
        LOG.info("placeholderPrefix            : Prefix of every placeholder");
        LOG.info("placeholderSuffix            : Suffix of every placeholder");
        LOG.info("scriptPlaceholderPrefix      : Prefix of every script placeholder");
        LOG.info("scriptPlaceholderSuffix      : Suffix of every script placeholder");
        LOG.info("lockRetryCount               : The maximum number of retries when trying to obtain a lock");
        LOG.info("jdbcProperties               : Properties to pass to the JDBC driver object");
        LOG.info("installedBy                  : Username that will be recorded in the schema history table");
        LOG.info("target                       : Target version up to which Flyway should use migrations");
        LOG.info("cherryPick                   : [teams] Comma separated list of migrations that Flyway should consider when migrating");
        LOG.info("skipExecutingMigrations      : [teams] Whether Flyway should skip actually executing the contents of the migrations");
        LOG.info("outOfOrder                   : Allows migrations to be run \"out of order\"");
        LOG.info("callbacks                    : Comma-separated list of FlywayCallback classes, or locations to scan for FlywayCallback classes");
        LOG.info("skipDefaultCallbacks         : Skips default callbacks (sql)");
        LOG.info("validateOnMigrate            : Validate when running migrate");
        LOG.info("validateMigrationNaming      : Validate file names of SQL migrations (including callbacks)");
        LOG.info("ignoreMissingMigrations      : Allow missing migrations when validating");
        LOG.info("ignoreIgnoredMigrations      : Allow ignored migrations when validating");
        LOG.info("ignorePendingMigrations      : Allow pending migrations when validating");
        LOG.info("ignoreFutureMigrations       : Allow future migrations when validating");
        LOG.info("ignoreMigrationPatterns      : [teams] Patterns of migrations and states to ignore during validate");
        LOG.info("cleanOnValidationError       : Automatically clean on a validation error");
        LOG.info("cleanDisabled                : Whether to disable clean");
        LOG.info("baselineVersion              : Version to tag schema with when executing baseline");
        LOG.info("baselineDescription          : Description to tag schema with when executing baseline");
        LOG.info("baselineOnMigrate            : Baseline on migrate against uninitialized non-empty schema");
        LOG.info("configFiles                  : Comma-separated list of config files to use");
        LOG.info("configFileEncoding           : Encoding to use when loading the config files");
        LOG.info("jarDirs                      : Comma-separated list of dirs for Jdbc drivers & Java migrations");
        LOG.info("createSchemas                : Whether Flyway should attempt to create the schemas specified in the schemas property");
        LOG.info("dryRunOutput                 : [teams] File where to output the SQL statements of a migration dry run");
        LOG.info("errorOverrides               : [teams] Rules to override specific SQL states and errors codes");
        LOG.info("oracle.sqlplus               : [teams] Enable Oracle SQL*Plus command support");
        LOG.info("licenseKey                   : [teams] Your Flyway license key");
        LOG.info("color                        : Whether to colorize output. Values: always, never, or auto (default)");
        LOG.info("outputFile                   : Send output to the specified file alongside the console");
        LOG.info("outputType                   : Serialise the output in the given format, Values: json");
        LOG.info("");
        LOG.info("Flags");
        LOG.info("-----");
        LOG.info("-X              : Print debug output");
        LOG.info("-q              : Suppress all output, except for errors and warnings");
        LOG.info("-n              : Suppress prompting for a user and password");
        LOG.info("--version, -v   : Print the Flyway version and exit");
        LOG.info("--help, -h, -?  : Print this usage info and exit");
        LOG.info("-community      : Run the Flyway Community Edition (default)");
        LOG.info("-teams          : Run the Flyway Teams Edition");
        LOG.info("");
        LOG.info("Example");
        LOG.info("-------");
        LOG.info("flyway -user=myuser -password=s3cr3t -url=jdbc:h2:mem -placeholders.abc=def migrate");
        LOG.info("");
        LOG.info("More info at https://rd.gt/3Cc1xKC");
        LOG.info("Learn more about Flyway Teams edition at https://rd.gt/2VzHpkY");
    }

    private static List<File> getJdbcDriverJarFiles() {
        File driversDir = new File(Main.getInstallationDir(), "drivers");
        File[] files = driversDir.listFiles((dir, name) -> name.endsWith(".jar"));
        if (files == null) {
            LOG.debug("Directory for Jdbc Drivers not found: " + driversDir.getAbsolutePath());
            return Collections.emptyList();
        }
        return Arrays.asList(files);
    }

    private static List<File> getJavaMigrationJarFiles(Map<String, String> config) {
        String jarDirs = config.get("flyway.jarDirs");
        if (!StringUtils.hasLength((String)jarDirs)) {
            return Collections.emptyList();
        }
        jarDirs = jarDirs.replace(File.pathSeparator, ",");
        String[] dirs = StringUtils.tokenizeToStringArray((String)jarDirs, (String)",");
        ArrayList<File> jarFiles = new ArrayList<File>();
        for (String dirName : dirs) {
            File dir = new File(dirName);
            File[] files = dir.listFiles((dir1, name) -> name.endsWith(".jar"));
            if (files == null) {
                LOG.error("Directory for Java Migrations not found: " + dirName);
                System.exit(1);
            }
            jarFiles.addAll(Arrays.asList(files));
        }
        return jarFiles;
    }

    protected static void loadConfigurationFromConfigFiles(Map<String, String> config, CommandLineArguments commandLineArguments, Map<String, String> envVars) {
        String encoding = Main.determineConfigurationFileEncoding(commandLineArguments, envVars);
        File installationDir = new File(Main.getInstallationDir());
        config.putAll(ConfigUtils.loadDefaultConfigurationFiles((File)installationDir, (String)encoding));
        for (File configFile : Main.determineConfigFilesFromArgs(commandLineArguments, envVars)) {
            config.putAll(ConfigUtils.loadConfigurationFile((File)configFile, (String)encoding, (boolean)true));
        }
    }

    private static void promptForCredentialsIfMissing(Map<String, String> config) {
        Console console = System.console();
        if (console == null) {
            return;
        }
        if (!config.containsKey("flyway.url")) {
            return;
        }
        String url = config.get("flyway.url");
        if (!config.containsKey("flyway.user") && !config.containsKey("flyway.oracle.kerberosConfigFile") && Main.needsUser(url, config.getOrDefault("flyway.password", null))) {
            config.put("flyway.user", console.readLine("Database user: ", new Object[0]));
        }
        if (!config.containsKey("flyway.password") && !config.containsKey("flyway.oracle.kerberosConfigFile") && Main.needsPassword(url, config.get("flyway.user"))) {
            char[] password = console.readPassword("Database password: ", new Object[0]);
            config.put("flyway.password", password == null ? "" : String.valueOf(password));
        }
    }

    protected static boolean needsUser(String url, String password) {
        DatabaseType databaseType = DatabaseTypeRegister.getDatabaseTypeForUrl((String)url);
        if (databaseType.detectUserRequiredByUrl(url)) {
            boolean externalAuthPropertiesRequired = databaseType.externalAuthPropertiesRequired(url, null, password);
            boolean externalAuthProviderHasUser = databaseType.getExternalAuthProperties(url, null).containsKey("user");
            return !externalAuthPropertiesRequired || !externalAuthProviderHasUser;
        }
        return false;
    }

    protected static boolean needsPassword(String url, String username) {
        DatabaseType databaseType = DatabaseTypeRegister.getDatabaseTypeForUrl((String)url);
        if (databaseType.detectPasswordRequiredByUrl(url)) {
            boolean externalAuthPropertiesRequired = databaseType.externalAuthPropertiesRequired(url, username, null);
            boolean externalAuthProviderHasUser = databaseType.getExternalAuthProperties(url, null).containsKey("password");
            return !externalAuthPropertiesRequired || !externalAuthProviderHasUser;
        }
        return false;
    }

    private static List<File> determineConfigFilesFromArgs(CommandLineArguments commandLineArguments, Map<String, String> envVars) {
        String workingDirectory;
        ArrayList<File> configFiles = new ArrayList<File>();
        String string = workingDirectory = commandLineArguments.isWorkingDirectorySet() ? commandLineArguments.getWorkingDirectory() : null;
        if (envVars.containsKey("flyway.configFiles")) {
            for (String file : StringUtils.tokenizeToStringArray((String)envVars.get("flyway.configFiles"), (String)",")) {
                configFiles.add(new File(workingDirectory, file));
            }
            return configFiles;
        }
        for (String file : commandLineArguments.getConfigFiles()) {
            configFiles.add(new File(workingDirectory, file));
        }
        return configFiles;
    }

    private static String getInstallationDir() {
        String path = ClassUtils.getLocationOnDisk(Main.class);
        return new File(path).getParentFile().getParentFile().getParentFile().getAbsolutePath();
    }

    private static String determineConfigurationFileEncoding(CommandLineArguments commandLineArguments, Map<String, String> envVars) {
        if (envVars.containsKey("flyway.configFileEncoding")) {
            return envVars.get("flyway.configFileEncoding");
        }
        if (commandLineArguments.isConfigFileEncodingSet()) {
            return commandLineArguments.getConfigFileEncoding();
        }
        return "UTF-8";
    }
}

