/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.bigquery;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.database.bigquery.BigQueryDatabase;
import org.flywaydb.database.bigquery.BigQueryTable;

public class BigQuerySchema
extends Schema<BigQueryDatabase, BigQueryTable> {
    BigQuerySchema(JdbcTemplate jdbcTemplate, BigQueryDatabase database, String name) {
        super(jdbcTemplate, (Database)database, name);
    }

    protected boolean doExists() throws SQLException {
        try {
            return this.jdbcTemplate.queryForInt("SELECT COUNT(table_name) FROM " + ((BigQueryDatabase)this.database).quote(new String[]{this.name}) + ".INFORMATION_SCHEMA.TABLES", new String[0]) >= 0;
        }
        catch (SQLException e) {
            if (e.getMessage().contains("NOT_FOUND")) {
                return false;
            }
            throw e;
        }
    }

    protected boolean doEmpty() throws SQLException {
        return this.doExists() && this.jdbcTemplate.queryForInt("SELECT COUNT(table_name) FROM " + ((BigQueryDatabase)this.database).quote(new String[]{this.name}) + ".INFORMATION_SCHEMA.TABLES", new String[0]) + this.jdbcTemplate.queryForInt("SELECT COUNT(routine_name) FROM " + ((BigQueryDatabase)this.database).quote(new String[]{this.name}) + ".INFORMATION_SCHEMA.ROUTINES", new String[0]) == 0;
    }

    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA IF NOT EXISTS " + ((BigQueryDatabase)this.database).quote(new String[]{this.name}), new Object[0]);
    }

    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP SCHEMA IF EXISTS " + ((BigQueryDatabase)this.database).quote(new String[]{this.name}) + " CASCADE", new Object[0]);
    }

    protected void doClean() throws SQLException {
        for (String statement : this.generateDropStatements("BASE TABLE", "TABLE")) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.generateDropStatements("EXTERNAL", "EXTERNAL TABLE")) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.generateDropStatements("VIEW", "VIEW")) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.generateDropStatements("MATERIALIZED VIEW", "MATERIALIZED VIEW")) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.generateDropStatementsForRoutines("FUNCTION")) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.generateDropStatementsForRoutines("PROCEDURE")) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
    }

    private List<String> generateDropStatementsForRoutines(String objType) throws SQLException {
        List objNames = this.jdbcTemplate.queryForStringList("SELECT routine_name FROM " + ((BigQueryDatabase)this.database).quote(new String[]{this.name}) + ".INFORMATION_SCHEMA.ROUTINES WHERE routine_type=?", new String[]{objType});
        ArrayList<String> statements = new ArrayList<String>();
        for (String objName : objNames) {
            statements.add("DROP " + objType + " IF EXISTS " + ((BigQueryDatabase)this.database).quote(new String[]{this.name, objName}));
        }
        return statements;
    }

    private List<String> generateDropStatements(String type, String objType) throws SQLException {
        List names = this.jdbcTemplate.queryForStringList("SELECT table_name FROM " + ((BigQueryDatabase)this.database).quote(new String[]{this.name}) + ".INFORMATION_SCHEMA.TABLES WHERE table_type=?", new String[]{type});
        ArrayList<String> statements = new ArrayList<String>();
        for (String domainName : names) {
            statements.add("DROP " + objType + " IF EXISTS " + ((BigQueryDatabase)this.database).quote(new String[]{this.name, domainName}));
        }
        return statements;
    }

    protected BigQueryTable[] doAllTables() throws SQLException {
        List tableNames = this.jdbcTemplate.queryForStringList("SELECT table_name FROM " + ((BigQueryDatabase)this.database).quote(new String[]{this.name}) + ".INFORMATION_SCHEMA.TABLES WHERE table_type='BASE TABLE'", new String[0]);
        BigQueryTable[] tables = new BigQueryTable[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tables[i] = new BigQueryTable(this.jdbcTemplate, (BigQueryDatabase)this.database, this, (String)tableNames.get(i));
        }
        return tables;
    }

    public Table getTable(String tableName) {
        return new BigQueryTable(this.jdbcTemplate, (BigQueryDatabase)this.database, this, tableName);
    }
}

