/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline.logging.console;

import org.flywaydb.core.api.logging.Log;

public class ConsoleLog
implements Log {
    private final Level level;

    public boolean isDebugEnabled() {
        return this.level == Level.DEBUG;
    }

    public void debug(String message) {
        if (this.isDebugEnabled()) {
            System.out.println("DEBUG: " + message);
        }
    }

    public void info(String message) {
        if (this.level.compareTo(Level.INFO) <= 0) {
            System.out.println(message);
        }
    }

    public void warn(String message) {
        System.out.println("WARNING: " + message);
    }

    public void error(String message) {
        System.err.println("ERROR: " + message);
    }

    public void error(String message, Exception e) {
        System.err.println("ERROR: " + message);
        e.printStackTrace(System.err);
    }

    public ConsoleLog(Level level) {
        this.level = level;
    }

    public static enum Level {
        DEBUG,
        INFO,
        WARN;

    }
}

