/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline.logging.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.flywaydb.commandline.CommandLineArguments;
import org.flywaydb.commandline.logging.console.ConsoleLog;
import org.flywaydb.commandline.logging.file.FileLog;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogCreator;

public class FileLogCreator
implements LogCreator {
    private final ConsoleLog.Level level;
    private final Path path;

    public FileLogCreator(CommandLineArguments commandLineArguments) {
        String outputFilepath = "";
        if (commandLineArguments.isOutputFileSet()) {
            outputFilepath = commandLineArguments.getOutputFile();
        }
        this.level = commandLineArguments.getLogLevel();
        this.path = Paths.get(outputFilepath, new String[0]);
        FileLogCreator.prepareOutputFile(this.path);
    }

    public Log createLogger(Class<?> clazz) {
        return new FileLog(this.path, this.level);
    }

    private static void prepareOutputFile(Path path) {
        try {
            Files.write(path, "".getBytes(), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        }
        catch (IOException exception) {
            throw new FlywayException("Could not initialize log file at " + path + ".", (Throwable)exception);
        }
    }
}

