/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline.utils;

import org.flywaydb.core.api.configuration.ClassicConfiguration;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.extensibility.RgDomainChecker;
import org.flywaydb.core.extensibility.RootTelemetryModel;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.plugin.PluginRegister;

public class TelemetryUtils {
    public static RootTelemetryModel populateRootTelemetry(RootTelemetryModel rootTelemetryModel, Configuration configuration, boolean isRedgateEmployee) {
        block12: {
            rootTelemetryModel.setApplicationVersion(VersionPrinter.getVersion());
            rootTelemetryModel.setApplicationEdition(VersionPrinter.EDITION.getDescription());
            rootTelemetryModel.setRedgateEmployee(isRedgateEmployee);
            ClassicConfiguration classicConfiguration = new ClassicConfiguration(configuration);
            if (classicConfiguration.getDataSource() != null) {
                try (JdbcConnectionFactory jdbcConnectionFactory = new JdbcConnectionFactory(classicConfiguration.getDataSource(), (Configuration)classicConfiguration, null);
                     Database database = jdbcConnectionFactory.getDatabaseType().createDatabase(configuration, false, jdbcConnectionFactory, null);){
                    rootTelemetryModel.setDatabaseEngine(database.getDatabaseType().getName());
                    break block12;
                }
            }
            rootTelemetryModel.setDatabaseEngine("UNKNOWN");
        }
        return rootTelemetryModel;
    }

    public static boolean isRedgateEmployee(PluginRegister pluginRegister, Configuration configuration) {
        RgDomainChecker domainChecker = (RgDomainChecker)pluginRegister.getPlugin(RgDomainChecker.class);
        if (domainChecker == null) {
            return false;
        }
        return domainChecker.isInDomain(configuration);
    }

    private TelemetryUtils() {
    }
}

