/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.net.URL;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.license.VersionPrinter;

public class MavenVersionChecker {
    private static final Log LOG = LogFactory.getLog(MavenVersionChecker.class);
    private static final String FLYWAY_URL = "https://repo1.maven.org/maven2/org/flywaydb/flyway-core/maven-metadata.xml";

    public static void checkForVersionUpdates() {
        try {
            MigrationVersion current = MigrationVersion.fromVersion((String)VersionPrinter.getVersion());
            MavenMetadata metadata = (MavenMetadata)new XmlMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(new URL(FLYWAY_URL), MavenMetadata.class);
            MigrationVersion latest = MigrationVersion.fromVersion((String)metadata.getVersioning().getRelease());
            if (current.compareTo(latest) < 0) {
                LOG.warn("This version of Flyway is out of date. Upgrade to Flyway " + latest + ": " + "https://rd.gt/3rXiSlV" + "\n");
            }
        }
        catch (Exception e) {
            LOG.debug("Unable to check for updates: " + e.getMessage());
        }
    }

    private MavenVersionChecker() {
    }

    private static class MavenMetadata {
        private MavenVersioning versioning;

        public void setVersioning(MavenVersioning versioning) {
            this.versioning = versioning;
        }

        public MavenVersioning getVersioning() {
            return this.versioning;
        }
    }

    private static class MavenVersioning {
        private String release;

        public void setRelease(String release) {
            this.release = release;
        }

        public String getRelease() {
            return this.release;
        }
    }
}

