/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.ignite.thin;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.community.database.ignite.thin.IgniteThinConnection;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;

public class IgniteThinDatabase
extends Database<IgniteThinConnection> {
    public IgniteThinDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    protected IgniteThinConnection doGetConnection(Connection connection) {
        return new IgniteThinConnection(this, connection);
    }

    protected MigrationVersion determineVersion() {
        try {
            int buildId = ((IgniteThinConnection)this.getMainConnection()).getJdbcTemplate().queryForInt("SELECT VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE NAME = 'info.BUILD_ID'", new String[0]);
            return MigrationVersion.fromVersion((String)(super.determineVersion().getVersion() + "." + buildId));
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to determine Apache Ignite build ID", e);
        }
    }

    public final void ensureSupported() {
        this.notifyDatabaseIsNotFormallySupported();
    }

    public String getRawCreateScript(Table table, boolean baseline) {
        return "CREATE TABLE IF NOT EXISTS " + table + " (\n    \"installed_rank\" INT NOT NULL,\n    \"version\" VARCHAR(50),\n    \"description\" VARCHAR(200) NOT NULL,\n    \"type\" VARCHAR(20) NOT NULL,\n    \"script\" VARCHAR(1000) NOT NULL,\n    \"checksum\" INT,\n    \"installed_by\" VARCHAR(100) NOT NULL,\n    \"installed_on\" TIMESTAMP NOT NULL,\n    \"execution_time\" INT NOT NULL,\n    \"success\" BOOLEAN NOT NULL,\n     PRIMARY KEY (\"installed_rank\")\n) WITH \"TEMPLATE=REPLICATED, BACKUPS=1,ATOMICITY=ATOMIC\";\n" + (baseline ? this.getBaselineStatement(table) + ";\n" : "") + "CREATE INDEX IF NOT EXISTS \"" + table.getSchema().getName() + "\".\"" + table.getName() + "_s_idx\" ON " + table + " (\"success\");";
    }

    public String getSelectStatement(Table table) {
        return "SELECT " + this.quote(new String[]{"installed_rank"}) + "," + this.quote(new String[]{"version"}) + "," + this.quote(new String[]{"description"}) + "," + this.quote(new String[]{"type"}) + "," + this.quote(new String[]{"script"}) + "," + this.quote(new String[]{"checksum"}) + "," + this.quote(new String[]{"installed_on"}) + "," + this.quote(new String[]{"installed_by"}) + "," + this.quote(new String[]{"execution_time"}) + "," + this.quote(new String[]{"success"}) + " FROM " + table + " WHERE " + this.quote(new String[]{"type"}) + " != 'TABLE' AND " + this.quote(new String[]{"installed_rank"}) + " > ? ORDER BY " + this.quote(new String[]{"installed_rank"});
    }

    public String getInsertStatement(Table table) {
        return "INSERT INTO " + table + " (" + this.quote(new String[]{"installed_rank"}) + ", " + this.quote(new String[]{"version"}) + ", " + this.quote(new String[]{"description"}) + ", " + this.quote(new String[]{"type"}) + ", " + this.quote(new String[]{"script"}) + ", " + this.quote(new String[]{"checksum"}) + ", " + this.quote(new String[]{"installed_by"}) + ", " + this.quote(new String[]{"installed_on"}) + ", " + this.quote(new String[]{"execution_time"}) + ", " + this.quote(new String[]{"success"}) + ") VALUES (?, ?, ?, ?, ?, ?, ?, CURRENT_TIMESTAMP, ?,?)";
    }

    protected String doGetCurrentUser() {
        String userName;
        try {
            Field connPropsField = ((IgniteThinConnection)this.getMainConnection()).getJdbcConnection().getClass().getDeclaredField("connProps");
            connPropsField.setAccessible(true);
            Object connProps = connPropsField.get(((IgniteThinConnection)this.getMainConnection()).getJdbcConnection());
            userName = (String)connProps.getClass().getMethod("getUsername", new Class[0]).invoke(connProps, new Object[0]);
            if (userName == null || userName.equals("")) {
                return "ignite";
            }
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new FlywayException((Throwable)e);
        }
        return userName;
    }

    public boolean supportsDdlTransactions() {
        return false;
    }

    public boolean useSingleConnection() {
        return super.useSingleConnection();
    }

    public boolean supportsMultiStatementTransactions() {
        return super.supportsMultiStatementTransactions();
    }

    public String getBooleanTrue() {
        return "1";
    }

    public String getBooleanFalse() {
        return "0";
    }

    public boolean catalogIsSchema() {
        return false;
    }
}

