/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.clickhouse;

import java.sql.Connection;
import org.flywaydb.community.database.ClickHouseDatabaseExtension;
import org.flywaydb.community.database.clickhouse.ClickHouseDatabase;
import org.flywaydb.community.database.clickhouse.ClickHouseParser;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.BaseDatabaseType;
import org.flywaydb.core.internal.database.base.CommunityDatabaseType;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;

public class ClickHouseDatabaseType
extends BaseDatabaseType
implements CommunityDatabaseType {
    public String getName() {
        return "ClickHouse";
    }

    public int getNullType() {
        return 0;
    }

    public boolean handlesJDBCUrl(String url) {
        return url.startsWith("jdbc:clickhouse:");
    }

    public String getDriverClass(String url, ClassLoader classLoader) {
        return "com.clickhouse.jdbc.ClickHouseDriver";
    }

    public String getBackupDriverClass(String url, ClassLoader classLoader) {
        return "ru.yandex.clickhouse.ClickHouseDriver";
    }

    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName.startsWith("ClickHouse");
    }

    public ClickHouseDatabase createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new ClickHouseDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new ClickHouseParser(configuration, parsingContext, 3);
    }

    public boolean detectUserRequiredByUrl(String url) {
        return !url.contains("user=");
    }

    public boolean detectPasswordRequiredByUrl(String url) {
        return !url.contains("password=");
    }

    public String getPluginVersion(Configuration config) {
        return ClickHouseDatabaseExtension.readVersion();
    }
}

