/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.clickhouse;

import java.sql.SQLException;
import java.util.Optional;
import org.flywaydb.community.database.clickhouse.ClickHouseConnection;
import org.flywaydb.community.database.clickhouse.ClickHouseDatabase;
import org.flywaydb.community.database.clickhouse.ClickHouseTable;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.util.StringUtils;

public class ClickHouseSchema
extends Schema<ClickHouseDatabase, ClickHouseTable> {
    private static final String DEFAULT_SCHEMA = "default";

    public ClickHouseSchema(JdbcTemplate jdbcTemplate, ClickHouseDatabase database, String name) {
        super(jdbcTemplate, (Database)database, name);
    }

    protected boolean doExists() throws SQLException {
        ClickHouseConnection systemConnection = ((ClickHouseDatabase)this.database).getSystemConnection();
        int i = systemConnection.getJdbcTemplate().queryForInt("SELECT COUNT() FROM system.databases WHERE name = ?", new String[]{this.name});
        return i > 0;
    }

    protected boolean doEmpty() throws SQLException {
        ClickHouseConnection systemConnection = ((ClickHouseDatabase)this.database).getSystemConnection();
        int i = systemConnection.getJdbcTemplate().queryForInt("SELECT COUNT() FROM system.tables WHERE database = ?", new String[]{this.name});
        return i == 0;
    }

    protected void doCreate() throws SQLException {
        ClickHouseConnection systemConnection = ((ClickHouseDatabase)this.database).getSystemConnection();
        String clusterName = ((ClickHouseDatabase)this.database).getClusterName();
        boolean isClustered = StringUtils.hasText((String)clusterName);
        systemConnection.getJdbcTemplate().executeStatement("CREATE DATABASE " + ((ClickHouseDatabase)this.database).quote(new String[]{this.name}) + (String)(isClustered ? " ON CLUSTER " + clusterName : ""));
    }

    protected void doDrop() throws SQLException {
        if (((ClickHouseConnection)((ClickHouseDatabase)this.database).getMainConnection()).getCurrentSchemaNameOrSearchPath().equals(this.name)) {
            ((ClickHouseConnection)((ClickHouseDatabase)this.database).getMainConnection()).doChangeCurrentSchemaOrSearchPathTo(Optional.ofNullable(((ClickHouseDatabase)this.database).getConfiguration().getDefaultSchema()).orElse(DEFAULT_SCHEMA));
        }
        String clusterName = ((ClickHouseDatabase)this.database).getClusterName();
        boolean isClustered = StringUtils.hasText((String)clusterName);
        this.jdbcTemplate.executeStatement("DROP DATABASE " + ((ClickHouseDatabase)this.database).quote(new String[]{this.name}) + (String)(isClustered ? " ON CLUSTER " + clusterName : ""));
    }

    protected void doClean() throws SQLException {
        for (ClickHouseTable table : (ClickHouseTable[])this.allTables()) {
            table.drop();
        }
    }

    protected ClickHouseTable[] doAllTables() throws SQLException {
        ClickHouseConnection systemConnection = ((ClickHouseDatabase)this.database).getSystemConnection();
        return (ClickHouseTable[])systemConnection.getJdbcTemplate().queryForStringList("SELECT name FROM system.tables WHERE database = ?", new String[]{this.name}).stream().map(this::getTable).toArray(ClickHouseTable[]::new);
    }

    public ClickHouseTable getTable(String tableName) {
        return new ClickHouseTable(this.jdbcTemplate, (ClickHouseDatabase)this.database, this, tableName);
    }
}

