/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.databricks;

import java.sql.SQLException;
import java.util.List;
import org.flywaydb.community.database.databricks.DatabricksDatabase;
import org.flywaydb.community.database.databricks.DatabricksSchema;
import org.flywaydb.core.internal.database.InsertRowLock;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;

public class DatabricksTable
extends Table<DatabricksDatabase, DatabricksSchema> {
    private final InsertRowLock insertRowLock;

    public DatabricksTable(JdbcTemplate jdbcTemplate, DatabricksDatabase database, DatabricksSchema schema, String name) {
        super(jdbcTemplate, (Database)database, (Schema)schema, name);
        this.insertRowLock = new InsertRowLock(jdbcTemplate);
    }

    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP TABLE " + ((DatabricksDatabase)this.database).quote(new String[]{((DatabricksSchema)this.schema).getName(), this.name}) + ";", new Object[0]);
    }

    protected boolean doExists() throws SQLException {
        if (!((DatabricksSchema)this.schema).exists()) {
            return false;
        }
        List tables = this.jdbcTemplate.queryForList("show tables in " + ((DatabricksDatabase)this.database).quote(new String[]{((DatabricksSchema)this.schema).getName()}) + " like '" + this.name + "';", new Object[0]);
        return tables.stream().anyMatch(table -> ((String)table.get("tableName")).equals(this.name));
    }

    protected void doLock() throws SQLException {
        String updateLockStatement = "UPDATE " + this + " SET installed_on = CURRENT_TIMESTAMP() WHERE version = '?' AND DESCRIPTION = 'flyway-lock';";
        String deleteExpiredLockStatement = " DELETE FROM " + this + " WHERE DESCRIPTION = 'flyway-lock' AND installed_on < TIMESTAMP '?';";
        if (this.lockDepth == 0) {
            this.insertRowLock.doLock(((DatabricksDatabase)this.database).getInsertStatement(this), updateLockStatement, deleteExpiredLockStatement, ((DatabricksDatabase)this.database).getBooleanTrue());
        }
    }

    protected void doUnlock() throws SQLException {
        if (this.lockDepth == 1) {
            this.insertRowLock.doUnlock(this.getDeleteLockTemplate());
        }
    }

    private String getDeleteLockTemplate() {
        return "DELETE FROM " + this + " WHERE version = '?' AND DESCRIPTION = 'flyway-lock';";
    }
}

