/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.databricks;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.community.database.databricks.DatabricksDatabase;
import org.flywaydb.community.database.databricks.DatabricksSchema;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.util.StringUtils;

public class DatabricksConnection
extends org.flywaydb.core.internal.database.base.Connection<DatabricksDatabase> {
    protected DatabricksConnection(DatabricksDatabase database, Connection connection) {
        super((Database)database, connection);
    }

    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        String defaultSchema = "default";
        String currentSchema = this.jdbcTemplate.queryForString("SELECT current_schema();", new String[0]);
        return currentSchema != null ? currentSchema : defaultSchema;
    }

    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        String sql = "USE SCHEMA" + ((DatabricksDatabase)this.database).doQuote(schema) + ";";
        this.jdbcTemplate.execute(sql, new Object[0]);
    }

    public Schema doGetCurrentSchema() throws SQLException {
        String currentSchema = this.getCurrentSchemaNameOrSearchPath();
        if (!StringUtils.hasText((String)currentSchema)) {
            throw new FlywayException("Unable to determine current schema as currentSchema is empty.");
        }
        return this.getSchema(currentSchema);
    }

    public Schema getSchema(String name) {
        return new DatabricksSchema(this.jdbcTemplate, (DatabricksDatabase)this.database, name);
    }
}

