/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.questdb;

import java.sql.SQLException;
import java.util.List;
import org.flywaydb.community.database.questdb.QuestDBDatabase;
import org.flywaydb.community.database.questdb.QuestDBTable;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;

public class QuestDBSchema
extends Schema<QuestDBDatabase, QuestDBTable> {
    public QuestDBSchema(JdbcTemplate jdbcTemplate, QuestDBDatabase database, String name) {
        super(jdbcTemplate, (Database)database, name);
    }

    protected boolean doExists() {
        return true;
    }

    protected boolean doEmpty() throws SQLException {
        List<String> tableNames = this.jdbcTemplate.queryForStringList("show tables", new String[0]).stream().filter(tbl -> !this.isSystem((String)tbl)).toList();
        return tableNames.isEmpty();
    }

    private boolean isSystem(String tableName) {
        return tableName.startsWith("sys.") || tableName.equalsIgnoreCase("telemetry_config") || tableName.equalsIgnoreCase("telemetry") || tableName.equalsIgnoreCase("_query_trace");
    }

    protected void doCreate() {
    }

    protected void doDrop() {
    }

    protected void doClean() {
        for (QuestDBTable table : (QuestDBTable[])this.allTables()) {
            table.drop();
        }
    }

    protected QuestDBTable[] doAllTables() throws SQLException {
        List<String> tableNames = this.jdbcTemplate.queryForStringList("show tables", new String[0]).stream().filter(tbl -> !this.isSystem((String)tbl)).toList();
        QuestDBTable[] tables = new QuestDBTable[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tables[i] = new QuestDBTable(this.jdbcTemplate, (QuestDBDatabase)this.database, this, tableNames.get(i));
        }
        return tables;
    }

    public QuestDBTable getTable(String tableName) {
        return new QuestDBTable(this.jdbcTemplate, (QuestDBDatabase)this.database, this, tableName);
    }
}

