/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.sqlserver;

import java.sql.SQLException;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.database.sqlserver.SQLServerDatabase;
import org.flywaydb.database.sqlserver.SQLServerSchema;

public class SQLServerTable
extends Table<SQLServerDatabase, SQLServerSchema> {
    private final String databaseName;

    public SQLServerTable(JdbcTemplate jdbcTemplate, SQLServerDatabase database, String databaseName, SQLServerSchema schema, String name) {
        super(jdbcTemplate, (Database)database, (Schema)schema, name);
        this.databaseName = databaseName;
    }

    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP TABLE " + String.valueOf((Object)this), new Object[0]);
    }

    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForBoolean("SELECT CAST(CASE WHEN EXISTS(  SELECT 1 FROM " + ((SQLServerDatabase)this.database).doQuote(this.databaseName) + ".INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA=? AND TABLE_NAME=?) THEN 1 ELSE 0 END AS BIT)", new String[]{((SQLServerSchema)this.schema).getName(), this.name});
    }

    protected void doLock() throws SQLException {
        this.jdbcTemplate.execute("select * from " + String.valueOf((Object)this) + " WITH (TABLOCKX)", new Object[0]);
    }

    void dropSystemVersioningIfPresent() throws SQLException {
        if (((SQLServerDatabase)this.database).supportsTemporalTables() && this.jdbcTemplate.queryForInt("SELECT temporal_type FROM sys.tables WHERE object_id = OBJECT_ID('" + String.valueOf((Object)this) + "', 'U')", new String[0]) == 2) {
            this.jdbcTemplate.execute("ALTER TABLE " + String.valueOf((Object)this) + " SET (SYSTEM_VERSIONING = OFF)", new Object[0]);
        }
    }

    public String toString() {
        return ((SQLServerDatabase)this.database).quote(new String[]{this.databaseName, ((SQLServerSchema)this.schema).getName(), this.name});
    }
}

