/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.test.dbunit;

import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbunit.database.AmbiguousTableNameException;
import org.dbunit.database.DatabaseSequenceFilter;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.QueryDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSetBuilder;
import org.dbunit.operation.DatabaseOperation;
import org.flywaydb.test.ExecutionListenerHelper;
import org.flywaydb.test.dbunit.DBUnitSupport;
import org.flywaydb.test.dbunit.DatabaseConnectionFactory;
import org.flywaydb.test.dbunit.DefaultDatabaseConnectionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public class DBUnitTestExecutionListener
extends AbstractTestExecutionListener
implements TestExecutionListener {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    @Autowired(required=false)
    protected DatabaseConnectionFactory dbConnectionFactory = new DefaultDatabaseConnectionFactory();
    private int order = 4500;

    public void beforeTestClass(TestContext testContext) throws Exception {
        Class testClass = testContext.getTestClass();
        Annotation annotation = AnnotationUtils.findAnnotation((Class)testClass, DBUnitSupport.class);
        if (annotation != null) {
            DBUnitSupport dbUnitAnnotaton = (DBUnitSupport)annotation;
            this.loadFiles(testContext, dbUnitAnnotaton);
        }
    }

    public void prepareTestInstance(TestContext testContext) throws Exception {
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        Method testMethod = testContext.getTestMethod();
        DBUnitSupport annotation = testMethod.getAnnotation(DBUnitSupport.class);
        if (annotation != null) {
            DBUnitSupport dbUnitAnnotaton = annotation;
            this.loadFiles(testContext, dbUnitAnnotaton);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTestMethod(TestContext testContext) throws Exception {
        Method testMethod = testContext.getTestMethod();
        DBUnitSupport annotation = testMethod.getAnnotation(DBUnitSupport.class);
        if (annotation != null) {
            DBUnitSupport dbUnitAnnotaton = annotation;
            String saveIt = dbUnitAnnotaton.saveFileAfterRun();
            String[] tables = dbUnitAnnotaton.saveTableAfterRun();
            if (saveIt != null && saveIt.trim().length() > 0) {
                String executionInfo = "";
                if (this.logger.isDebugEnabled()) {
                    executionInfo = ExecutionListenerHelper.getExecutionInformation((TestContext)testContext);
                    this.logger.debug((Object)("******** Start save information '" + executionInfo + "' info file '" + saveIt + "'."));
                }
                DataSource ds = this.getSaveDataSource(testContext);
                IDatabaseConnection con = this.getConnection(ds, testContext);
                try {
                    IDataSet dataSet = this.getDataSetToExport(tables, con);
                    File fileToExport = this.getFileToExport(saveIt);
                    FileWriter fileWriter = new FileWriter(fileToExport);
                    FlatXmlDataSet.write((IDataSet)dataSet, (Writer)fileWriter);
                }
                finally {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("******** Close database connection " + con));
                    }
                    con.close();
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("******** Finished save information '" + executionInfo + "' info file '" + saveIt + "'."));
                }
            }
        }
    }

    public void afterTestClass(TestContext testContext) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFiles(TestContext testContext, DBUnitSupport dbUnitAnnotation) throws Exception {
        String[] loadFiles = dbUnitAnnotation.loadFilesForRun();
        if (loadFiles != null && loadFiles.length > 0) {
            String executionInfo = "";
            if (this.logger.isDebugEnabled()) {
                executionInfo = ExecutionListenerHelper.getExecutionInformation((TestContext)testContext);
                this.logger.debug((Object)("******** Load files  '" + executionInfo + "'."));
            }
            for (int i = 0; i < loadFiles.length; i += 2) {
                String operationName = loadFiles[i];
                String fileResource = loadFiles[i + 1];
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("******** load file '" + executionInfo + "' op='" + operationName + "' - '" + fileResource + "'."));
                }
                DatabaseOperation operation = this.getOperation(operationName);
                ClassPathResource resource = new ClassPathResource(fileResource);
                try (InputStream is = resource.getInputStream();){
                    DataSource ds = this.getSaveDataSource(testContext);
                    IDatabaseConnection con = this.getConnection(ds, testContext);
                    try {
                        FlatXmlDataSet dataSet = this.getFileDataSet(is);
                        operation.execute(con, (IDataSet)dataSet);
                        continue;
                    }
                    finally {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("******** Close database connection " + con));
                        }
                        con.close();
                    }
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("******** Finished load files '" + executionInfo + "'."));
            }
        }
    }

    private DatabaseOperation getOperation(String operation) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        String upOper = operation.toUpperCase();
        Field field = DatabaseOperation.class.getField(upOper);
        if (field == null || !field.getType().equals(DatabaseOperation.class)) {
            throw new IllegalArgumentException("Operation " + operation + " is unknown");
        }
        DatabaseOperation result = (DatabaseOperation)field.get(DatabaseOperation.class);
        return result;
    }

    private File getFileToExport(String fileName) {
        String fileToExportName = fileName;
        if (fileName.startsWith(".")) {
            File curDir = new File(".");
            fileToExportName = curDir.getAbsolutePath() + File.separator + fileName;
        }
        File fileToExport = new File(fileToExportName);
        fileToExport.getParentFile().mkdirs();
        return fileToExport;
    }

    private IDataSet getDataSetToExport(String[] tables, IDatabaseConnection con) throws DataSetException, SQLException, AmbiguousTableNameException {
        DatabaseSequenceFilter filter = new DatabaseSequenceFilter(con);
        IDataSet dataSetToExport = null;
        if (tables == null || tables.length == 0) {
            dataSetToExport = con.createDataSet();
            dataSetToExport = new FilteredDataSet((ITableFilter)filter, dataSetToExport);
        } else {
            QueryDataSet qDataSet = new QueryDataSet(con);
            if (tables.length % 2 != 0) {
                throw new IllegalArgumentException("Contract {<Table Name>,<SELECT_QUERY>} is brocken.");
            }
            for (int i = 0; i < tables.length; i += 2) {
                String table = tables[i].toUpperCase();
                String query = tables[i + 1];
                if (query == null || query.trim().length() == 0) {
                    query = "SELECT * FROM " + table;
                }
                qDataSet.addTable(table, query);
            }
            dataSetToExport = qDataSet;
        }
        return dataSetToExport;
    }

    private DataSource getSaveDataSource(TestContext testContext) {
        ApplicationContext appContext = testContext.getApplicationContext();
        if (appContext != null) {
            DataSource dataSource = this.getBean(appContext, DataSource.class);
            if (dataSource != null) {
                return dataSource;
            }
            throw new IllegalArgumentException("The test application context has no configured data source!");
        }
        throw new IllegalArgumentException("The test configuration contains no application context.");
    }

    protected IDatabaseConnection getConnection(DataSource dataSource, TestContext context) throws Exception {
        Connection con = dataSource.getConnection();
        DatabaseMetaData databaseMetaData = con.getMetaData();
        IDatabaseConnection connection = null;
        try {
            DatabaseConnectionFactory factory = (DatabaseConnectionFactory)context.getApplicationContext().getBean(DatabaseConnectionFactory.class);
            if (factory != null) {
                this.dbConnectionFactory = factory;
            }
        }
        catch (Exception e) {
            this.logger.debug((Object)String.format("We ignore if we could not find a instance of '%s'", DatabaseConnectionFactory.class.getName()));
        }
        if (this.dbConnectionFactory != null) {
            connection = this.dbConnectionFactory.createConnection(con, databaseMetaData);
            return connection;
        }
        return null;
    }

    private FlatXmlDataSet getFileDataSet(InputStream is) throws Exception {
        FlatXmlDataSetBuilder builder = new FlatXmlDataSetBuilder();
        return builder.build(is);
    }

    private DataSource getBean(ApplicationContext context, Class<?> classType) {
        DataSource result = null;
        String[] names = context.getBeanNamesForType(classType);
        if (names != null && names.length > 0) {
            result = (DataSource)context.getBean(names[0]);
        }
        return result;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }
}

