/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.test.junit;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.flywaydb.core.Flyway;
import org.flywaydb.test.ExecutionListenerHelper;
import org.flywaydb.test.annotation.FlywayTest;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public class FlywayTestExecutionListener
extends AbstractTestExecutionListener
implements TestExecutionListener {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private int order = 4000;

    protected Log getLogger() {
        return this.logger;
    }

    public void beforeTestClass(TestContext testContext) throws Exception {
        Class testClass = testContext.getTestClass();
        Annotation annotation = AnnotationUtils.findAnnotation((Class)testClass, FlywayTest.class);
        this.dbResetWithAnotation(testContext, (FlywayTest)annotation);
    }

    public void prepareTestInstance(TestContext testContext) throws Exception {
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        Method testMethod = testContext.getTestMethod();
        FlywayTest annotation = testMethod.getAnnotation(FlywayTest.class);
        this.dbResetWithAnotation(testContext, annotation);
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
    }

    public void afterTestClass(TestContext testContext) throws Exception {
    }

    private void dbResetWithAnotation(TestContext testContext, FlywayTest annotation) {
        if (annotation != null) {
            Flyway flyWay = null;
            ApplicationContext appContext = testContext.getApplicationContext();
            String executionInfo = ExecutionListenerHelper.getExecutionInformation(testContext);
            if (appContext != null) {
                flyWay = this.getBean(appContext, Flyway.class, annotation.flywayName());
                if (flyWay != null) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("---> Start reset database for  '" + executionInfo + "'."));
                    }
                    if (annotation.invokeCleanDB()) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("******** Clean database for  '" + executionInfo + "'."));
                        }
                        flyWay.clean();
                    }
                    if (annotation.invokeInitDB() || annotation.invokeBaselineDB()) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("******** Baseline database  for  '" + executionInfo + "'."));
                        }
                        flyWay.baseline();
                    }
                    if (annotation.invokeMigrateDB()) {
                        String[] locations = annotation.locationsForMigrate();
                        if (locations == null || locations.length == 0) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("******** Default migrate database for  '" + executionInfo + "'."));
                            }
                            flyWay.migrate();
                        } else {
                            this.locationsMigrationHandling(annotation, flyWay, executionInfo);
                        }
                    }
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("<--- Finished reset database  for  '" + executionInfo + "'."));
                    }
                    return;
                }
                throw new IllegalArgumentException("Annotation " + annotation.getClass() + " was set, but no Flyway configuration was given.");
            }
            throw new IllegalArgumentException("Annotation " + annotation.getClass() + " was set, but no configuration was given.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void locationsMigrationHandling(FlywayTest annotation, Flyway flyWay, String executionInfo) {
        String[] locations = annotation.locationsForMigrate();
        String[] oldLocations = flyWay.getLocations();
        boolean override = annotation.overrideLocations();
        try {
            String[] useLocations = null;
            if (override) {
                useLocations = locations;
            } else {
                useLocations = Arrays.copyOf(oldLocations, oldLocations.length + locations.length);
                System.arraycopy(locations, 0, useLocations, oldLocations.length, locations.length);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("******** Start migration from locations directories '%s'  for  '%s'.", Arrays.asList(useLocations), executionInfo));
            }
            flyWay.setLocations(useLocations);
            flyWay.migrate();
        }
        finally {
            flyWay.setLocations(oldLocations);
        }
    }

    private Flyway getBean(ApplicationContext context, Class<?> classType, String idName) {
        Flyway result = null;
        String[] names = context.getBeanNamesForType(classType);
        if (names != null && names.length > 0) {
            result = idName == null || idName.trim().isEmpty() ? (Flyway)context.getBean(names[0]) : (Flyway)context.getBean(idName);
        }
        return result;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }
}

