/*
 * Decompiled with CFR 0.152.
 */
package org.force66.beantester.valuegens;

import java.lang.reflect.Modifier;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.force66.beantester.utils.InstantiationUtils;
import org.force66.beantester.valuegens.ArrayValueGenerator;
import org.force66.beantester.valuegens.GenericValueGenerator;
import org.force66.beantester.valuegens.InterfaceValueGenerator;
import org.force66.beantester.valuegens.PrimitiveValueGenerator;
import org.force66.beantester.valuegens.TemporalValueGenerator;
import org.force66.beantester.valuegens.ValueGenerator;

public class ValueGeneratorFactory {
    private static final ValueGenerator<?>[] STOCK_GENERATORS = new ValueGenerator[]{new PrimitiveValueGenerator(Boolean.class, new Object[]{Boolean.TRUE, Boolean.FALSE}), new PrimitiveValueGenerator(Long.class, new Object[]{0L}), new PrimitiveValueGenerator(Integer.class, "int", new Object[]{0}), new PrimitiveValueGenerator(Double.class, new Object[]{0.0}), new PrimitiveValueGenerator(Byte.class, new Object[]{(byte)-128}), new PrimitiveValueGenerator(Float.class, new Object[]{Float.valueOf(0.0f)}), new PrimitiveValueGenerator(Short.class, new Object[]{Short.valueOf("0")}), new PrimitiveValueGenerator(Character.class, "char", new Object[]{Character.valueOf('A')}), new TemporalValueGenerator(java.util.Date.class), new TemporalValueGenerator(Date.class), new TemporalValueGenerator(Time.class), new TemporalValueGenerator(Timestamp.class), new GenericValueGenerator(new Object[]{InstantiationUtils.newXMLGregorianCalendar()})};
    private Map<Class<?>, ValueGenerator<?>> registeredGeneratorMap = new HashMap();

    public void registerGenerator(Class<?> klass, ValueGenerator<?> generator) {
        Validate.notNull(klass, (String)"Null class not allowed", (Object[])new Object[0]);
        Validate.notNull(generator, (String)"Null generator not allowed", (Object[])new Object[0]);
        this.registeredGeneratorMap.put(klass, generator);
    }

    public ValueGenerator<?> forClass(Class<?> targetClass) {
        ValueGenerator<Object> gen;
        Validate.notNull(targetClass, (String)"Null class not allowed", (Object[])new Object[0]);
        ValueGenerator<?> generator = this.registeredGeneratorMap.get(targetClass);
        if (generator == null) {
            for (ValueGenerator<?> gen2 : STOCK_GENERATORS) {
                if (!gen2.canGenerate(targetClass)) continue;
                this.registeredGeneratorMap.put(targetClass, gen2);
                return gen2;
            }
        } else {
            return generator;
        }
        if (targetClass.isInterface()) {
            gen = new InterfaceValueGenerator(targetClass);
            this.registerGenerator(targetClass, gen);
            return gen;
        }
        if (Modifier.isAbstract(targetClass.getModifiers())) {
            return null;
        }
        if (targetClass.isEnum()) {
            return this.registerGenericGenerator(targetClass, targetClass.getEnumConstants());
        }
        if (targetClass.isArray()) {
            gen = new ArrayValueGenerator(targetClass, this);
            this.registerGenerator(targetClass, gen);
            return gen;
        }
        if (Class.class.equals(targetClass)) {
            return this.registerGenericGenerator(targetClass, new Object[]{Object.class});
        }
        return this.registerGenericGenerator(targetClass, new Object[]{InstantiationUtils.safeNewInstance(this, targetClass)});
    }

    protected ValueGenerator<?> registerGenericGenerator(Class<?> targetClass, Object[] objValues) {
        GenericValueGenerator gen = new GenericValueGenerator(objValues);
        this.registerGenerator(targetClass, gen);
        return gen;
    }
}

