/*
 * Decompiled with CFR 0.152.
 */
package org.fossnova.finder;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class FactoryFinder {
    private static final String PREFIX = "META-INF/services/";
    private static final AccessControlContext ACC = System.getSecurityManager() != null ? AccessController.getContext() : null;

    private FactoryFinder() {
    }

    public static <T> T find(Class<T> factoryIface) {
        return FactoryFinder.find(factoryIface, null);
    }

    public static <T> T find(Class<T> factoryIface, String fallbackImpl) {
        if (factoryIface == null) {
            throw new IllegalArgumentException("Factory interface class cannot be null");
        }
        ClassLoader loader = factoryIface.getClassLoader();
        String factoryImplClassName = FactoryFinder.getFactoryImplFromSystemProperty(factoryIface.getName());
        if (factoryImplClassName == null) {
            factoryImplClassName = FactoryFinder.getFactoryImplClassNameFromServiceProvider(factoryIface.getName(), loader);
        }
        if (factoryImplClassName == null) {
            factoryImplClassName = fallbackImpl;
        }
        if (factoryImplClassName == null) {
            throw new RuntimeException("Factory implementation for interface '" + factoryIface.getName() + "' not found");
        }
        return (T)FactoryFinder.newInstance(factoryImplClassName, loader);
    }

    private static String getFactoryImplFromSystemProperty(final String factoryIfaceName) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(factoryIfaceName);
                }
            }, ACC);
        }
        return System.getProperty(factoryIfaceName);
    }

    private static String getFactoryImplClassNameFromServiceProvider(String factoryIfaceName, ClassLoader loader) {
        String resourceName = PREFIX + factoryIfaceName;
        String factoryImplName = null;
        try (InputStream is = loader.getResourceAsStream(resourceName);){
            if (is != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                factoryImplName = reader.readLine().trim();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return FactoryFinder.isDefined(factoryImplName) ? factoryImplName : null;
    }

    private static Object newInstance(String factoryImplClassName, ClassLoader loader) {
        try {
            Class<?> factory = Class.forName(factoryImplClassName, true, loader);
            return factory.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Factory '" + factoryImplClassName + "' not found", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Factory '" + factoryImplClassName + "' not instatiated", e);
        }
    }

    private static boolean isDefined(String s) {
        return s != null && s.length() > 0;
    }
}

