/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.async;

import com.apple.foundationdb.KeySelector;
import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.MutationType;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.ReadTransactionContext;
import com.apple.foundationdb.StreamingMode;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.TransactionContext;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncIterable;
import com.apple.foundationdb.async.AsyncIterator;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.apple.foundationdb.tuple.Tuple;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;

@API(value=API.Status.MAINTAINED)
public class RankedSet {
    private static final int LEVEL_FAN_POW = 4;
    private static final int[] LEVEL_FAN_VALUES = new int[8];
    public static final int MAX_LEVELS = 8;
    public static final int DEFAULT_LEVELS = 6;
    protected final Subspace subspace;
    protected final Executor executor;
    protected final int nlevels;
    private static final byte[] EMPTY_ARRAY;
    private static final byte[] ZERO_ARRAY;

    private static byte[] encodeLong(long count) {
        return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(count).array();
    }

    private static long decodeLong(byte[] v) {
        return ByteBuffer.wrap(v).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    public RankedSet(Subspace subspace, Executor executor, int nlevels) {
        if (nlevels < 2 || nlevels > 8) {
            throw new IllegalArgumentException("levels must be between 2 and 8");
        }
        this.subspace = subspace;
        this.executor = executor;
        this.nlevels = nlevels;
    }

    public RankedSet(Subspace subspace, Executor executor) {
        this(subspace, executor, 6);
    }

    public CompletableFuture<Void> init(TransactionContext tc) {
        return this.initLevels(tc);
    }

    public CompletableFuture<Boolean> initNeeded(ReadTransactionContext tc) {
        return this.containsCheckedKey(tc, EMPTY_ARRAY).thenApply(b -> b == false);
    }

    public CompletableFuture<Boolean> add(TransactionContext tc, byte[] key) {
        RankedSet.checkKey(key);
        long keyHash = this.hashKey(key);
        return tc.runAsync(tr -> this.containsCheckedKey((ReadTransactionContext)tr, key).thenCompose(exists -> {
            if (exists.booleanValue()) {
                return AsyncUtil.READY_FALSE;
            }
            ArrayList futures = new ArrayList(this.nlevels);
            for (int li = 0; li < this.nlevels; ++li) {
                CompletionStage future;
                int level = li;
                if (level == 0) {
                    tr.set(this.subspace.pack(Tuple.from((Object[])new Object[]{level, key})), RankedSet.encodeLong(1L));
                    future = AsyncUtil.DONE;
                } else if ((keyHash & (long)LEVEL_FAN_VALUES[level]) != 0L) {
                    future = this.getPreviousKey((TransactionContext)tr, level, key).thenApply(prevKey -> {
                        tr.mutate(MutationType.ADD, this.subspace.pack(Tuple.from((Object[])new Object[]{level, prevKey})), RankedSet.encodeLong(1L));
                        return null;
                    });
                } else {
                    future = AsyncUtil.whenAll(futures);
                    futures = new ArrayList(this.nlevels - li);
                    future = ((CompletableFuture)future).thenCompose(vignore -> this.getPreviousKey((TransactionContext)tr, level, key).thenCompose(prevKey -> {
                        CompletionStage prevCount = tr.get(this.subspace.pack(Tuple.from((Object[])new Object[]{level, prevKey}))).thenApply(RankedSet::decodeLong);
                        CompletableFuture<Long> newPrevCount = this.countRange((ReadTransactionContext)tr, level - 1, (byte[])prevKey, key);
                        return CompletableFuture.allOf(new CompletableFuture[]{prevCount, newPrevCount}).thenApply(arg_0 -> this.lambda$null$2((CompletableFuture)prevCount, newPrevCount, tr, level, prevKey, key, arg_0));
                    }));
                }
                futures.add(future);
            }
            return AsyncUtil.whenAll(futures).thenApply(vignore -> true);
        }));
    }

    public CompletableFuture<Void> clear(TransactionContext tc) {
        Range range = this.subspace.range();
        return tc.runAsync(tr -> {
            tr.clear(range);
            return this.initLevels((TransactionContext)tr);
        });
    }

    public CompletableFuture<Boolean> contains(ReadTransactionContext tc, byte[] key) {
        RankedSet.checkKey(key);
        return this.containsCheckedKey(tc, key);
    }

    private CompletableFuture<Boolean> containsCheckedKey(ReadTransactionContext tc, byte[] key) {
        return tc.readAsync(tr -> tr.get(this.subspace.pack(Tuple.from((Object[])new Object[]{0, key}))).thenApply(Objects::nonNull));
    }

    public CompletableFuture<byte[]> getNth(ReadTransactionContext tc, long rank) {
        if (rank < 0L) {
            return CompletableFuture.completedFuture(null);
        }
        return tc.readAsync(tr -> {
            NthLookup nth = new NthLookup(rank);
            return AsyncUtil.whileTrue(() -> this.nextLookup(nth, (ReadTransaction)tr), (Executor)this.executor).thenApply(vignore -> nth.getKey());
        });
    }

    public List<byte[]> getRangeList(ReadTransactionContext tc, byte[] beginKey, byte[] endKey) {
        return (List)tc.read(tr -> (List)this.getRange((ReadTransaction)tr, beginKey, endKey).asList().join());
    }

    public AsyncIterable<byte[]> getRange(ReadTransaction tr, byte[] beginKey, byte[] endKey) {
        RankedSet.checkKey(beginKey);
        return AsyncUtil.mapIterable((AsyncIterable)tr.getRange(this.subspace.pack(Tuple.from((Object[])new Object[]{0, beginKey})), this.subspace.pack(Tuple.from((Object[])new Object[]{0, endKey}))), keyValue -> {
            Tuple t = this.subspace.unpack(keyValue.getKey());
            return t.getBytes(1);
        });
    }

    public CompletableFuture<Void> preloadForLookup(ReadTransaction tr) {
        return tr.getRange(this.subspace.range(), this.nlevels, true).asList().thenApply(l -> null);
    }

    protected CompletableFuture<Boolean> nextLookup(Lookup lookup, ReadTransaction tr) {
        return lookup.next(tr);
    }

    protected <T> AsyncIterator<T> lookupIterator(AsyncIterable<T> iterable) {
        return iterable.iterator();
    }

    protected void nextLookupKey(long duration, boolean newIter, boolean hasNext, int level, boolean rankLookup) {
    }

    public CompletableFuture<Long> rank(ReadTransactionContext tc, byte[] key) {
        return this.rank(tc, key, true);
    }

    public CompletableFuture<Long> rank(ReadTransactionContext tc, byte[] key, boolean nullIfMissing) {
        RankedSet.checkKey(key);
        return tc.readAsync(tr -> {
            if (nullIfMissing) {
                return this.containsCheckedKey((ReadTransactionContext)tr, key).thenCompose(exists -> {
                    if (!exists.booleanValue()) {
                        return CompletableFuture.completedFuture(null);
                    }
                    return this.rankLookup((ReadTransaction)tr, key, true);
                });
            }
            return this.rankLookup((ReadTransaction)tr, key, false);
        });
    }

    private CompletableFuture<Long> rankLookup(ReadTransaction tr, byte[] key, boolean keyShouldBePresent) {
        RankLookup rank = new RankLookup(key, keyShouldBePresent);
        return AsyncUtil.whileTrue(() -> this.nextLookup(rank, tr), (Executor)this.executor).thenApply(vignore -> rank.getRank());
    }

    public CompletableFuture<Boolean> remove(TransactionContext tc, byte[] key) {
        RankedSet.checkKey(key);
        return tc.runAsync(tr -> this.containsCheckedKey((ReadTransactionContext)tr, key).thenCompose(exists -> {
            if (!exists.booleanValue()) {
                return AsyncUtil.READY_FALSE;
            }
            ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>(this.nlevels);
            for (int li = 0; li < this.nlevels; ++li) {
                CompletionStage future;
                int level = li;
                byte[] k = this.subspace.pack(Tuple.from((Object[])new Object[]{level, key}));
                CompletableFuture cf = tr.get(k);
                if (level == 0) {
                    future = cf.thenApply(c -> {
                        if (c != null) {
                            tr.clear(k);
                        }
                        return null;
                    });
                } else {
                    CompletableFuture<byte[]> prevKeyF = this.getPreviousKey((TransactionContext)tr, level, key);
                    future = CompletableFuture.allOf(cf, prevKeyF).thenApply(vignore -> {
                        byte[] c = (byte[])cf.join();
                        long countChange = -1L;
                        if (c != null) {
                            countChange += RankedSet.decodeLong(c);
                            tr.clear(k);
                        }
                        tr.mutate(MutationType.ADD, this.subspace.pack(Tuple.from((Object[])new Object[]{level, prevKeyF.join()})), RankedSet.encodeLong(countChange));
                        return null;
                    });
                }
                futures.add(future);
            }
            return AsyncUtil.whenAll(futures).thenApply(vignore -> true);
        }));
    }

    public CompletableFuture<Long> size(ReadTransactionContext tc) {
        Range r = this.subspace.get((Object)(this.nlevels - 1)).range();
        return tc.readAsync(tr -> AsyncUtil.mapIterable((AsyncIterable)tr.getRange(r), keyValue -> RankedSet.decodeLong(keyValue.getValue())).asList().thenApply(longs -> longs.stream().reduce(0L, Long::sum)));
    }

    protected Consistency checkConsistency(ReadTransactionContext tc) {
        return (Consistency)tc.read(tr -> {
            block0: for (int level = 1; level < this.nlevels; ++level) {
                byte[] prevKey = null;
                long prevCount = 0L;
                AsyncIterator it = tr.getRange(this.subspace.range(Tuple.from((Object[])new Object[]{level}))).iterator();
                while (true) {
                    long count;
                    byte[] nextKey;
                    boolean more;
                    KeyValue kv = (more = it.hasNext()) ? (KeyValue)it.next() : null;
                    byte[] byArray = nextKey = kv == null ? null : this.subspace.unpack(kv.getKey()).getBytes(1);
                    if (prevKey != null && prevCount != (count = this.countRange((ReadTransactionContext)tr, level - 1, prevKey, nextKey).join().longValue())) {
                        return new Consistency(level, prevCount, count, this.toDebugString(tc));
                    }
                    if (!more) continue block0;
                    prevKey = nextKey;
                    prevCount = RankedSet.decodeLong(kv.getValue());
                }
            }
            return new Consistency();
        });
    }

    protected String toDebugString(ReadTransactionContext tc) {
        return (String)tc.read(tr -> {
            StringBuilder str = new StringBuilder();
            for (int level = 0; level < this.nlevels; ++level) {
                if (level > 0) {
                    str.setLength(str.length() - 2);
                    str.append("\n");
                }
                str.append("L").append(level).append(": ");
                for (KeyValue kv : tr.getRange(this.subspace.range(Tuple.from((Object[])new Object[]{level})))) {
                    byte[] key = this.subspace.unpack(kv.getKey()).getBytes(1);
                    long count = RankedSet.decodeLong(kv.getValue());
                    str.append("'").append(ByteArrayUtil2.loggable(key)).append("': ").append(count).append(", ");
                }
            }
            return str.toString();
        });
    }

    private static void checkKey(byte[] key) {
        if (key.length == 0) {
            throw new IllegalArgumentException("Empty key not allowed");
        }
    }

    private CompletableFuture<Long> countRange(ReadTransactionContext tc, int level, byte[] beginKey, byte[] endKey) {
        return tc.readAsync(tr -> AsyncUtil.mapIterable((AsyncIterable)tr.getRange(beginKey == null ? this.subspace.range((Tuple)Tuple.from((Object[])new Object[]{Integer.valueOf((int)level)})).begin : this.subspace.pack(Tuple.from((Object[])new Object[]{level, beginKey})), endKey == null ? this.subspace.range((Tuple)Tuple.from((Object[])new Object[]{Integer.valueOf((int)level)})).end : this.subspace.pack(Tuple.from((Object[])new Object[]{level, endKey}))), keyValue -> RankedSet.decodeLong(keyValue.getValue())).asList().thenApply(longs -> longs.stream().reduce(0L, Long::sum)));
    }

    private CompletableFuture<byte[]> getPreviousKey(TransactionContext tc, int level, byte[] key) {
        byte[] k = this.subspace.pack(Tuple.from((Object[])new Object[]{level, key}));
        CompletableFuture kf = (CompletableFuture)tc.run(tr -> tr.snapshot().getRange(KeySelector.lastLessThan((byte[])k), KeySelector.firstGreaterOrEqual((byte[])k), 1).asList().thenApply(kvs -> {
            byte[] prevk = ((KeyValue)kvs.get(0)).getKey();
            byte[] exclusiveBegin = ByteArrayUtil.join((byte[][])new byte[][]{prevk, ZERO_ARRAY});
            tr.addReadConflictRange(exclusiveBegin, k);
            tr.addReadConflictKey(this.subspace.pack(Tuple.from((Object[])new Object[]{0, this.subspace.unpack(prevk).getBytes(1)})));
            return prevk;
        }));
        return kf.thenApply(prevk -> this.subspace.unpack(prevk).getBytes(1));
    }

    private long hashKey(byte[] k) {
        return Arrays.hashCode(k);
    }

    private CompletableFuture<Void> initLevels(TransactionContext tc) {
        return tc.runAsync(tr -> {
            ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>(this.nlevels);
            for (int level = 0; level < this.nlevels; ++level) {
                byte[] k = this.subspace.pack(Tuple.from((Object[])new Object[]{level, EMPTY_ARRAY}));
                byte[] v = RankedSet.encodeLong(0L);
                futures.add(tr.get(k).thenApply(value -> {
                    if (value == null) {
                        tr.set(k, v);
                    }
                    return null;
                }));
            }
            return AsyncUtil.whenAll(futures);
        });
    }

    private /* synthetic */ Void lambda$null$2(CompletableFuture prevCount, CompletableFuture newPrevCount, Transaction tr, int level, byte[] prevKey, byte[] key, Void vignore2) {
        long count = (Long)prevCount.join() - (Long)newPrevCount.join() + 1L;
        tr.set(this.subspace.pack(Tuple.from((Object[])new Object[]{level, prevKey})), RankedSet.encodeLong((Long)newPrevCount.join()));
        tr.set(this.subspace.pack(Tuple.from((Object[])new Object[]{level, key})), RankedSet.encodeLong(count));
        return null;
    }

    static /* synthetic */ byte[] access$000() {
        return EMPTY_ARRAY;
    }

    static {
        for (int i = 0; i < 8; ++i) {
            RankedSet.LEVEL_FAN_VALUES[i] = (1 << i * 4) - 1;
        }
        EMPTY_ARRAY = new byte[0];
        ZERO_ARRAY = new byte[]{0};
    }

    protected static class Consistency {
        private final boolean consistent;
        private final int level;
        private final long prevCount;
        private final long count;
        private String structure;

        public Consistency(int level, long prevCount, long count, String structure) {
            this.level = level;
            this.prevCount = prevCount;
            this.count = count;
            this.structure = structure;
            this.consistent = false;
        }

        public Consistency() {
            this.consistent = true;
            this.level = 0;
            this.prevCount = 0L;
            this.count = 0L;
            this.structure = null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(67);
            sb.append("Consistency{").append("consistent:").append(this.isConsistent()).append(", level:").append(this.level).append(", prevCount:").append(this.prevCount).append(", count:").append(this.count).append(", structure:'").append(this.structure).append('\'').append('}');
            return sb.toString();
        }

        public boolean isConsistent() {
            return this.consistent;
        }
    }

    class RankLookup
    implements Lookup {
        private final byte[] key;
        private final boolean keyShouldBePresent;
        private byte[] rankKey = RankedSet.access$000();
        private long rank = 0L;
        private Subspace levelSubspace;
        private int level;
        private AsyncIterator<KeyValue> asyncIterator;
        private long lastCount;

        public RankLookup(byte[] key, boolean keyShouldBePresent) {
            this.level = RankedSet.this.nlevels;
            this.asyncIterator = null;
            this.key = key;
            this.keyShouldBePresent = keyShouldBePresent;
        }

        public long getRank() {
            return this.rank;
        }

        @Override
        public CompletableFuture<Boolean> next(ReadTransaction tr) {
            boolean newIterator;
            boolean bl = newIterator = this.asyncIterator == null;
            if (newIterator) {
                --this.level;
                if (this.level < 0) {
                    return AsyncUtil.READY_FALSE;
                }
                this.levelSubspace = RankedSet.this.subspace.get((Object)this.level);
                this.asyncIterator = RankedSet.this.lookupIterator(tr.getRange(KeySelector.firstGreaterOrEqual((byte[])this.levelSubspace.pack((Object)this.rankKey)), KeySelector.firstGreaterThan((byte[])this.levelSubspace.pack((Object)this.key)), 0, false, StreamingMode.WANT_ALL));
                this.lastCount = 0L;
            }
            long startTime = System.nanoTime();
            CompletableFuture onHasNext = this.asyncIterator.onHasNext();
            boolean wasDone = onHasNext.isDone();
            return onHasNext.thenApply(hasNext -> {
                if (!wasDone) {
                    RankedSet.this.nextLookupKey(System.nanoTime() - startTime, newIterator, (boolean)hasNext, this.level, true);
                }
                if (!hasNext.booleanValue()) {
                    this.asyncIterator = null;
                    this.rank -= this.lastCount;
                    if (Arrays.equals(this.rankKey, this.key)) {
                        return false;
                    }
                    if (!this.keyShouldBePresent && this.level == 0 && this.lastCount > 0L) {
                        ++this.rank;
                    }
                    return true;
                }
                KeyValue kv = (KeyValue)this.asyncIterator.next();
                this.rankKey = this.levelSubspace.unpack(kv.getKey()).getBytes(0);
                this.lastCount = RankedSet.decodeLong(kv.getValue());
                this.rank += this.lastCount;
                return true;
            });
        }
    }

    protected static interface Lookup {
        public CompletableFuture<Boolean> next(ReadTransaction var1);
    }

    class NthLookup
    implements Lookup {
        private long rank;
        private byte[] key = RankedSet.access$000();
        private int level;
        private Subspace levelSubspace;
        private AsyncIterator<KeyValue> asyncIterator;

        public NthLookup(long rank) {
            this.level = RankedSet.this.nlevels;
            this.asyncIterator = null;
            this.rank = rank;
        }

        public byte[] getKey() {
            return this.key;
        }

        @Override
        public CompletableFuture<Boolean> next(ReadTransaction tr) {
            boolean newIterator;
            boolean bl = newIterator = this.asyncIterator == null;
            if (newIterator) {
                --this.level;
                if (this.level < 0) {
                    this.key = null;
                    return AsyncUtil.READY_FALSE;
                }
                this.levelSubspace = RankedSet.this.subspace.get((Object)this.level);
                this.asyncIterator = RankedSet.this.lookupIterator(tr.getRange(this.levelSubspace.pack((Object)this.key), this.levelSubspace.range().end, 0, false, StreamingMode.WANT_ALL));
            }
            long startTime = System.nanoTime();
            CompletableFuture onHasNext = this.asyncIterator.onHasNext();
            boolean wasDone = onHasNext.isDone();
            return onHasNext.thenApply(hasNext -> {
                if (!wasDone) {
                    RankedSet.this.nextLookupKey(System.nanoTime() - startTime, newIterator, (boolean)hasNext, this.level, false);
                }
                if (!hasNext.booleanValue()) {
                    this.key = null;
                    return false;
                }
                KeyValue kv = (KeyValue)this.asyncIterator.next();
                this.key = this.levelSubspace.unpack(kv.getKey()).getBytes(0);
                if (this.rank == 0L && this.key.length > 0) {
                    return false;
                }
                long count = RankedSet.decodeLong(kv.getValue());
                if (count > this.rank) {
                    this.asyncIterator = null;
                    return true;
                }
                this.rank -= count;
                return true;
            });
        }
    }
}

