/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.map;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.map.BunchedMapException;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class BunchedSerializationException
extends BunchedMapException {
    @Nullable
    private byte[] data;
    @Nullable
    private Object value;

    public BunchedSerializationException(@Nonnull String message) {
        super(message);
    }

    public BunchedSerializationException(@Nonnull String message, @Nonnull Throwable cause) {
        super(message, cause);
    }

    @Nonnull
    public BunchedSerializationException setData(@Nonnull byte[] data) {
        this.data = Arrays.copyOf(data, data.length);
        this.addLogInfo("data", (Object)ByteArrayUtil2.loggable(data));
        return this;
    }

    @Nullable
    public byte[] getData() {
        return this.data == null ? null : Arrays.copyOf(this.data, this.data.length);
    }

    @Nonnull
    public BunchedSerializationException setValue(@Nonnull Object value) {
        this.value = value;
        this.addLogInfo("value", value);
        return this;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }
}

