/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.synchronizedsession;

import com.apple.foundationdb.MutationType;
import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.synchronizedsession.SynchronizedSessionLockedException;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.util.LogMessageKeys;
import com.apple.foundationdb.util.LoggableException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.EXPERIMENTAL)
public class SynchronizedSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(SynchronizedSession.class);
    @Nonnull
    private Subspace lockSubspace;
    @Nonnull
    private UUID sessionId;
    private long leaseLengthMillis;
    @Nonnull
    private final byte[] lockSessionIdSubspaceKey;
    @Nonnull
    private final byte[] lockSessionLeaseEndTimeSubspaceKey;
    private static final Object LOCK_SESSION_ID_KEY = 0L;
    private static final Object LOCK_SESSION_TIME_KEY = 1L;

    public SynchronizedSession(@Nonnull Subspace lockSubspace, @Nonnull UUID sessionId, long leaseLengthMillis) {
        this.lockSubspace = lockSubspace;
        this.sessionId = sessionId;
        this.leaseLengthMillis = leaseLengthMillis;
        this.lockSessionIdSubspaceKey = lockSubspace.subspace(Tuple.from((Object[])new Object[]{LOCK_SESSION_ID_KEY})).pack();
        this.lockSessionLeaseEndTimeSubspaceKey = lockSubspace.subspace(Tuple.from((Object[])new Object[]{LOCK_SESSION_TIME_KEY})).pack();
    }

    public CompletableFuture<Void> initializeSessionAsync(@Nonnull Transaction tr) {
        return this.getLockSessionId(tr).thenAcceptBoth(this.getLockSessionTime(tr.snapshot()), (lockSessionId, sessionTime) -> {
            if (lockSessionId == null) {
                this.takeSessionLock(tr);
            } else {
                if (lockSessionId.equals(this.sessionId)) {
                    throw new LoggableException("session id already exists in subspace").addLogInfo(new Object[]{LogMessageKeys.SUBSPACE, ByteArrayUtil2.loggable(this.lockSubspace.getKey())}).addLogInfo(new Object[]{LogMessageKeys.SESSION_ID, this.sessionId});
                }
                if (sessionTime == null) {
                    LOGGER.warn("Session ID is set but session time is not", new Object[]{LogMessageKeys.SUBSPACE, ByteArrayUtil2.loggable(this.lockSubspace.getKey()), LogMessageKeys.SESSION_ID, this.sessionId});
                    this.takeSessionLock(tr);
                } else if (sessionTime < System.currentTimeMillis()) {
                    this.takeSessionLock(tr);
                } else {
                    throw new SynchronizedSessionLockedException("Failed to initialize the session because of an existing session in progress", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.SUBSPACE, ByteArrayUtil2.loggable(this.lockSubspace.getKey())}).addLogInfo(new Object[]{LogMessageKeys.SESSION_ID, this.sessionId}).addLogInfo(new Object[]{LogMessageKeys.EXISTING_SESSION, lockSessionId}).addLogInfo(new Object[]{LogMessageKeys.EXISTING_SESSION_EXPIRE_TIME, sessionTime});
                }
            }
        });
    }

    private void takeSessionLock(@Nonnull Transaction tr) {
        this.setLockSessionId(tr);
        this.updateLockSessionLeaseEndTime(tr);
    }

    @Nonnull
    public UUID getSessionId() {
        return this.sessionId;
    }

    public CompletableFuture<Void> checkLockAsync(@Nonnull Transaction tr) {
        return this.getLockSessionId(tr).thenCompose(lockSessionId -> {
            if (!this.sessionId.equals(lockSessionId)) {
                throw new SynchronizedSessionLockedException("Failed to continue the session", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.SUBSPACE, ByteArrayUtil2.loggable(this.lockSubspace.getKey())}).addLogInfo(new Object[]{LogMessageKeys.SESSION_ID, this.sessionId}).addLogInfo(new Object[]{LogMessageKeys.EXISTING_SESSION, lockSessionId});
            }
            return AsyncUtil.DONE;
        });
    }

    public CompletableFuture<Void> releaseLock(@Nonnull Transaction tr) {
        return this.getLockSessionId(tr).thenApply(lockSessionId -> {
            if (this.sessionId.equals(lockSessionId)) {
                tr.clear(this.lockSubspace.range());
            }
            return null;
        });
    }

    private CompletableFuture<UUID> getLockSessionId(@Nonnull Transaction tr) {
        return tr.get(this.lockSessionIdSubspaceKey).thenApply(value -> value == null ? null : Tuple.fromBytes((byte[])value).getUUID(0));
    }

    private void setLockSessionId(@Nonnull Transaction tr) {
        tr.set(this.lockSessionIdSubspaceKey, Tuple.from((Object[])new Object[]{this.sessionId}).pack());
    }

    private CompletableFuture<Long> getLockSessionTime(@Nonnull ReadTransaction tr) {
        return tr.get(this.lockSessionLeaseEndTimeSubspaceKey).thenApply(value -> value == null ? null : Long.valueOf(Tuple.fromBytes((byte[])value).getLong(0)));
    }

    public void updateLockSessionLeaseEndTime(@Nonnull Transaction tr) {
        long leaseEndTime = System.currentTimeMillis() + this.leaseLengthMillis;
        tr.mutate(MutationType.BYTE_MAX, this.lockSessionLeaseEndTimeSubspaceKey, Tuple.from((Object[])new Object[]{leaseEndTime}).pack());
    }
}

