/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.tuple;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleUtil;
import java.math.BigInteger;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class TupleHelpers {
    @Nonnull
    public static final Tuple EMPTY = Tuple.from((Object[])new Object[0]);

    @Nonnull
    public static Tuple set(@Nonnull Tuple src, int index, Object value) {
        List items = src.getItems();
        items.set(index, value);
        return Tuple.fromList((List)items);
    }

    @Nonnull
    public static Tuple subTuple(@Nonnull Tuple src, int start, int end) {
        List items = src.getItems();
        return Tuple.fromList(items.subList(start, end));
    }

    @API(value=API.Status.MAINTAINED)
    public static int compare(@Nonnull Tuple t1, @Nonnull Tuple t2) {
        int t1Len = t1.size();
        int t2Len = t2.size();
        int len = Math.min(t1Len, t2Len);
        for (int i = 0; i < len; ++i) {
            int rc = TupleUtil.compareItems((Object)t1.get(i), (Object)t2.get(i));
            if (rc == 0) continue;
            return rc;
        }
        return t1Len - t2Len;
    }

    public static boolean equals(@Nullable Tuple t1, @Nullable Tuple t2) {
        if (t1 == null) {
            return t2 == null;
        }
        return t2 != null && (t1 == t2 || TupleHelpers.compare(t1, t2) == 0);
    }

    public static Number negate(@Nonnull Number number) {
        if (number instanceof Long || number instanceof Integer || number instanceof Short || number instanceof Byte) {
            long l = number.longValue();
            if (l == Long.MIN_VALUE) {
                return BigInteger.valueOf(l).negate();
            }
            return -l;
        }
        if (number instanceof BigInteger) {
            BigInteger n = ((BigInteger)number).negate();
            if (n.equals(BigInteger.valueOf(Long.MIN_VALUE))) {
                return Long.MIN_VALUE;
            }
            return n;
        }
        if (number instanceof Double || number instanceof Float) {
            return -number.doubleValue();
        }
        throw new IllegalArgumentException("Not an allowed number type from a Tuple: " + number.getClass());
    }

    private TupleHelpers() {
    }
}

