package com.apple.foundationdb;

/**
 * A set of options that can be set on a {@link Database}.
 */
public class DatabaseOptions extends OptionsSet {
	public DatabaseOptions( OptionConsumer consumer ) { super(consumer); }

	/**
	 * Set the size of the client location cache. Raising this value can boost performance in very large databases where clients access data in a near-random pattern. Defaults to 100000.
	 * 
	 * @param value Max location cache entries
	 */
	public void setLocationCacheSize(long value) { setOption(10, value); }

	/**
	 * Set the maximum number of watches allowed to be outstanding on a database connection. Increasing this number could result in increased resource usage. Reducing this number will not cancel any outstanding watches. Defaults to 10000 and cannot be larger than 1000000.
	 * 
	 * @param value Max outstanding watches
	 */
	public void setMaxWatches(long value) { setOption(20, value); }

	/**
	 * Specify the machine ID that was passed to fdbserver processes running on the same machine as this client, for better location-aware load balancing.
	 * 
	 * @param value Hexadecimal ID
	 */
	public void setMachineId(String value) { setOption(21, value); }

	/**
	 * Specify the datacenter ID that was passed to fdbserver processes running in the same datacenter as this client, for better location-aware load balancing.
	 * 
	 * @param value Hexadecimal ID
	 */
	public void setDatacenterId(String value) { setOption(22, value); }
}
